/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openai.mock;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.test.infra.openai.mock.MockExpectation;
import org.apache.camel.test.infra.openai.mock.OpenAIMockBuilder;
import org.apache.camel.test.infra.openai.mock.OpenAIMockServerHandler;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIMock
implements BeforeEachCallback,
AfterEachCallback {
    private static final Logger LOG = LoggerFactory.getLogger(OpenAIMock.class);
    private HttpServer server;
    private final List<MockExpectation> expectations = new ArrayList<MockExpectation>();
    private final OpenAIMockBuilder builder;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private ExecutorService executor;

    public OpenAIMock() {
        this.builder = new OpenAIMockBuilder(this, this.expectations);
    }

    public OpenAIMockBuilder builder() {
        return this.builder;
    }

    public String getBaseUrl() {
        if (this.server == null) {
            throw new IllegalStateException("Mock server not started. Call beforeEach() first.");
        }
        return "http://localhost:" + this.server.getAddress().getPort();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.server = HttpServer.create(new InetSocketAddress(0), 0);
        this.server.createContext("/", new OpenAIMockServerHandler(this.expectations, this.objectMapper));
        this.executor = Executors.newSingleThreadExecutor();
        this.server.setExecutor(this.executor);
        this.server.start();
        LOG.info("Mock web server started on {}", (Object)this.server.getAddress());
    }

    public void afterEach(ExtensionContext context) throws IOException {
        if (this.server != null) {
            this.server.stop(0);
            this.executor.shutdownNow();
            LOG.info("Mock web server shut down");
        }
    }
}

