/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openai.mock;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.camel.test.infra.openai.mock.MockExpectation;
import org.apache.camel.test.infra.openai.mock.RequestHandler;

public class OpenAIMockServerHandler
implements HttpHandler {
    private final RequestHandler requestHandler;

    public OpenAIMockServerHandler(List<MockExpectation> expectations, ObjectMapper objectMapper) {
        this.requestHandler = new RequestHandler(expectations, objectMapper);
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        if ("POST".equalsIgnoreCase(exchange.getRequestMethod())) {
            try {
                byte[] response = this.requestHandler.handleRequest(exchange).getBytes();
                if (exchange.getResponseCode() == -1) {
                    exchange.sendResponseHeaders(200, response.length);
                }
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(response);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

