/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ollama.services;

import com.github.dockerjava.api.model.DeviceRequest;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.ollama.services.OllamaInfraService;
import org.apache.camel.test.infra.ollama.services.OllamaServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.ollama.OllamaContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=OllamaInfraService.class, description="Build and run LLMs with Ollama", serviceAlias={"ollama"})
public class OllamaLocalContainerInfraService
implements OllamaInfraService,
ContainerService<OllamaContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(OllamaLocalContainerInfraService.class);
    public static final String CONTAINER_NAME = LocalPropertyResolver.getProperty(OllamaLocalContainerInfraService.class, (String)"ollama.container");
    private final OllamaContainer container;
    private final OllamaServiceConfiguration configuration;

    public OllamaLocalContainerInfraService() {
        this.container = this.initContainer();
        this.configuration = new DefaultServiceConfiguration();
    }

    public OllamaLocalContainerInfraService(OllamaServiceConfiguration serviceConfiguration) {
        this.configuration = serviceConfiguration;
        this.container = this.initContainer();
    }

    protected OllamaContainer initContainer() {
        class TestInfraOllamaContainer
        extends OllamaContainer {
            public TestInfraOllamaContainer(boolean fixedPort) {
                String name;
                String enableGpu;
                super(DockerImageName.parse((String)CONTAINER_NAME).asCompatibleSubstituteFor("ollama/ollama"));
                String homeDir = System.getenv("HOME");
                if (homeDir != null) {
                    try {
                        Path ollamaDir = Paths.get(homeDir, ".camel-test", "ollama");
                        Files.createDirectories(ollamaDir, new FileAttribute[0]);
                        this.withFileSystemBind(ollamaDir.toString(), "/root/.ollama", BindMode.READ_WRITE);
                        LOG.info("Binding host directory {} to container path /root/.ollama", (Object)ollamaDir);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to create Ollama data directory, continuing without bind mount", (Throwable)e);
                    }
                }
                if ("enabled".equalsIgnoreCase(enableGpu = LocalPropertyResolver.getProperty(OllamaLocalContainerInfraService.class, (String)"ollama.container.enable.gpu"))) {
                    LOG.info("Enabling GPU support for Ollama container");
                    this.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withDeviceRequests(Arrays.asList(new DeviceRequest().withCount(Integer.valueOf(-1)).withCapabilities(Arrays.asList(Arrays.asList("gpu"))))));
                } else {
                    LOG.info("GPU support disabled");
                }
                if (fixedPort) {
                    this.addFixedExposedPort(11434, 11434);
                }
                if ((name = ContainerEnvironmentUtil.containerName(OllamaLocalContainerInfraService.this.getClass())) != null) {
                    this.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
                }
            }
        }
        return new TestInfraOllamaContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    @Override
    public String getEndpoint() {
        return this.container.getEndpoint();
    }

    @Override
    public String getModel() {
        return this.modelName();
    }

    @Override
    public String modelName() {
        return this.configuration.modelName();
    }

    @Override
    public String baseUrl() {
        return this.container.getEndpoint();
    }

    @Override
    public String baseUrlV1() {
        return this.container.getEndpoint() + "/v1";
    }

    @Override
    public String apiKey() {
        return this.configuration.apiKey();
    }

    public void registerProperties() {
        System.setProperty("ollama.endpoint", this.getEndpoint());
    }

    public void initialize() {
        LOG.info("Trying to start the Ollama container");
        this.container.start();
        LOG.info("Pulling the model {}", (Object)this.getModel());
        try {
            this.container.execInContainer(new String[]{"ollama", "pull", this.getModel()});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.registerProperties();
        LOG.info("Ollama instance running at {}", (Object)this.getEndpoint());
    }

    public void shutdown() {
        LOG.info("Stopping the Ollama container");
        this.container.stop();
    }

    public OllamaContainer getContainer() {
        return this.container;
    }

    private static class DefaultServiceConfiguration
    implements OllamaServiceConfiguration {
        private DefaultServiceConfiguration() {
        }

        @Override
        public String modelName() {
            return LocalPropertyResolver.getProperty(OllamaLocalContainerInfraService.class, (String)"ollama.model");
        }

        @Override
        public String apiKey() {
            return LocalPropertyResolver.getProperty(OllamaLocalContainerInfraService.class, (String)"ollama.api.key");
        }
    }
}

