/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.neo4j.services;

import java.time.Duration;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.neo4j.services.Neo4jInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Neo4jContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=Neo4jInfraService.class, description="Neo4j Database", serviceAlias={"neo4j"})
public class Neo4jLocalContainerInfraService
implements Neo4jInfraService,
ContainerService<Neo4jContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(Neo4jLocalContainerInfraService.class);
    private static final String ADMIN_USER = "neo4j";
    private final Neo4jContainer container;

    public Neo4jLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(Neo4jLocalContainerInfraService.class, (String)"neo4j.container"));
    }

    public Neo4jLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public Neo4jLocalContainerInfraService(Neo4jContainer container) {
        this.container = container;
    }

    protected Neo4jContainer initContainer(final String imageName) {
        class TestInfraNeo4jContainer
        extends Neo4jContainer {
            public TestInfraNeo4jContainer(boolean fixedPort) {
                super(DockerImageName.parse((String)string).asCompatibleSubstituteFor(Neo4jLocalContainerInfraService.ADMIN_USER));
                this.withStartupTimeout(Duration.ofMinutes(3L));
                this.withRandomPassword();
                if (fixedPort) {
                    this.addFixedExposedPort(7687, 7687);
                    this.addFixedExposedPort(7473, 7473);
                    this.addFixedExposedPort(7474, 7474);
                }
            }
        }
        return new TestInfraNeo4jContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("neo4j.database.uri", this.getNeo4jDatabaseUri());
        System.setProperty("neo4j.database.user", this.getNeo4jDatabaseUser());
        System.setProperty("neo4j.database.password", this.getNeo4jDatabasePassword());
    }

    public void initialize() {
        LOG.info("Trying to start the Neo4j container");
        this.container.start();
        this.registerProperties();
        LOG.info("Neo4j instance running at {}", (Object)this.getNeo4jDatabaseUri());
    }

    public void shutdown() {
        LOG.info("Stopping the Neo4j container");
        this.container.stop();
    }

    public Neo4jContainer getContainer() {
        return this.container;
    }

    @Override
    public String getNeo4jDatabaseUri() {
        return this.container.getBoltUrl();
    }

    @Override
    public String getNeo4jDatabaseUser() {
        return ADMIN_USER;
    }

    @Override
    public String getNeo4jDatabasePassword() {
        return this.container.getAdminPassword();
    }
}

