/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.nats.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.nats.services.NatsInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@InfraService(service=NatsInfraService.class, description="Messaging Platform NATS", serviceAlias={"nats"})
public class NatsLocalContainerInfraService
implements NatsInfraService,
ContainerService<GenericContainer> {
    public static final String CONTAINER_NAME = "nats";
    private static final int PORT = 4222;
    private static final Logger LOG = LoggerFactory.getLogger(NatsLocalContainerInfraService.class);
    private final GenericContainer container;

    public NatsLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(NatsLocalContainerInfraService.class, (String)"nats.container"));
    }

    public NatsLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName, CONTAINER_NAME);
    }

    protected GenericContainer initContainer(final String imageName, final String containerName) {
        class NatsContainer
        extends GenericContainer<NatsContainer> {
            public NatsContainer(boolean fixedPort) {
                super(string);
                ((NatsContainer)this.withNetworkAliases(new String[]{containerName})).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Listening.*for.*route.*connections.*", (int)1));
                if (fixedPort) {
                    this.addFixedExposedPort(4222, 4222);
                } else {
                    this.withExposedPorts(new Integer[]{4222});
                }
            }
        }
        return new NatsContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("nat.service.address", this.getServiceAddress());
    }

    public void initialize() {
        LOG.info("Trying to start the Nats container");
        this.container.start();
        this.registerProperties();
        LOG.info("Nats instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Nats container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    protected String getHost() {
        return this.container.getHost();
    }

    protected int getPort() {
        return this.container.getMappedPort(4222);
    }

    @Override
    public String getServiceAddress() {
        return String.format("%s:%d", this.getHost(), this.getPort());
    }
}

