/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.minio.services;

import java.time.Duration;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.minio.services.MinioInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;

@InfraService(service=MinioInfraService.class, description="MinIO Object Storage, S3 compatible", serviceAlias={"minio"})
public class MinioLocalContainerInfraService
implements MinioInfraService,
ContainerService<GenericContainer<?>> {
    public static final String CONTAINER_NAME = "minio";
    private static final String ACCESS_KEY;
    private static final String SECRET_KEY;
    private static final int BROKER_PORT = 9000;
    private static final Logger LOG;
    private final GenericContainer<?> container;

    public MinioLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(MinioLocalContainerInfraService.class, (String)"minio.container"));
    }

    public MinioLocalContainerInfraService(String containerName) {
        this.container = this.initContainer(containerName, CONTAINER_NAME);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public MinioLocalContainerInfraService(GenericContainer<?> container) {
        this.container = container;
    }

    protected GenericContainer<?> initContainer(final String imageName, final String containerName) {
        class MinioContainer
        extends GenericContainer<MinioContainer> {
            public MinioContainer(boolean fixedPort) {
                super(string);
                ((MinioContainer)((MinioContainer)((MinioContainer)((MinioContainer)this.withNetworkAliases(new String[]{containerName})).withEnv("MINIO_ACCESS_KEY", MinioLocalContainerInfraService.this.accessKey())).withEnv("MINIO_SECRET_KEY", MinioLocalContainerInfraService.this.secretKey())).withCommand("server /data")).waitingFor(new HttpWaitStrategy().forPath("/minio/health/live").forPort(9000).withStartupTimeout(Duration.ofSeconds(10L)));
                if (fixedPort) {
                    this.addFixedExposedPort(9000, 9000);
                } else {
                    this.withExposedPorts(new Integer[]{9000});
                }
            }
        }
        return new MinioContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("minio.access.key", this.accessKey());
        System.setProperty("minio.secret.key", this.secretKey());
        System.setProperty("minio.service.host", this.host());
        System.setProperty("minio.service.port", String.valueOf(this.port()));
    }

    public void initialize() {
        LOG.info("Trying to start the Minio container");
        this.container.start();
        this.registerProperties();
        LOG.info("Minio instance running at {}:{}", (Object)this.host(), (Object)this.port());
    }

    public void shutdown() {
        LOG.info("Stopping the Minio container");
        this.container.stop();
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    @Override
    public String secretKey() {
        return SECRET_KEY;
    }

    @Override
    public String accessKey() {
        return ACCESS_KEY;
    }

    @Override
    public int port() {
        return this.container.getMappedPort(9000);
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    static {
        LOG = LoggerFactory.getLogger(MinioLocalContainerInfraService.class);
        ACCESS_KEY = System.getProperty("minio.access.key", "testAccessKey");
        SECRET_KEY = System.getProperty("minio.secret.key", "testSecretKey");
    }
}

