/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.milvus.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.milvus.services.MilvusInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.milvus.MilvusContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=MilvusInfraService.class, description="Milvus Vector Database", serviceAlias={"milvus"})
public class MilvusLocalContainerInfraService
implements MilvusInfraService,
ContainerService<MilvusContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(MilvusLocalContainerInfraService.class);
    private final MilvusContainer container;

    public MilvusLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(MilvusLocalContainerInfraService.class, (String)"milvus.container"));
    }

    public MilvusLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public MilvusLocalContainerInfraService(MilvusContainer container) {
        this.container = container;
    }

    protected MilvusContainer initContainer(String imageName) {
        return (MilvusContainer)new MilvusContainer(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor("milvusdb/milvus")).withStartupTimeout(Duration.ofMinutes(3L));
    }

    public void registerProperties() {
        System.setProperty("milvus.endpoint.url", this.getMilvusEndpointUrl());
        System.setProperty("milvus.endpoint.host", this.getMilvusHost());
        System.setProperty("milvus.endpoint.port", String.valueOf(this.getMilvusPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the Milvus container");
        this.container.start();
        this.registerProperties();
        LOG.info("Milvus instance running at {}", (Object)this.getMilvusEndpointUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the Milvus container");
        this.container.stop();
    }

    public MilvusContainer getContainer() {
        return this.container;
    }

    @Override
    public String getMilvusEndpointUrl() {
        return this.container.getEndpoint();
    }

    @Override
    public String getMilvusHost() {
        URL url = null;
        try {
            url = new URL(this.container.getEndpoint());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url.getHost();
    }

    @Override
    public int getMilvusPort() {
        URL url = null;
        try {
            url = new URL(this.container.getEndpoint());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url.getPort();
    }
}

