/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.microprofile.lra.services;

import com.github.dockerjava.api.model.Network;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.microprofile.lra.services.MicroprofileLRAInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=MicroprofileLRAInfraService.class, description="MicroProfile LRA provides a simple, loosely coupled transaction model for microservices that is based on the SAGA pattern for distributed transaction.", serviceAlias={"microprofile"}, serviceImplementationAlias={"lra"})
public class MicroprofileLRALocalContainerInfraService
implements MicroprofileLRAInfraService,
ContainerService<GenericContainer> {
    public static final String CONTAINER_NAME = "microprofile-lra";
    private static final Logger LOG = LoggerFactory.getLogger(MicroprofileLRALocalContainerInfraService.class);
    private final GenericContainer container;

    public MicroprofileLRALocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(MicroprofileLRALocalContainerInfraService.class, (String)"microprofile.lra.container"));
    }

    public MicroprofileLRALocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName, CONTAINER_NAME);
    }

    public MicroprofileLRALocalContainerInfraService(GenericContainer container) {
        this.container = container;
    }

    public GenericContainer initContainer(final String imageName, final String networkAlias) {
        class MicroprofileLRAContainer
        extends GenericContainer<MicroprofileLRAContainer> {
            public MicroprofileLRAContainer(boolean fixedPort) {
                super(DockerImageName.parse((String)string));
                ((MicroprofileLRAContainer)((MicroprofileLRAContainer)this.withNetworkAliases(new String[]{networkAlias})).waitingFor((WaitStrategy)Wait.forListeningPort())).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*lra-coordinator-quarkus.*Listening on.*", (int)1));
                if (fixedPort) {
                    this.addFixedExposedPort(8080, 8080);
                } else {
                    this.withExposedPorts(new Integer[]{8080});
                }
            }
        }
        return new MicroprofileLRAContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("microprofile.lra.service.address", this.getServiceAddress());
        System.setProperty("microprofile.lra.port", String.valueOf(this.port()));
        System.setProperty("microprofile.lra.host", this.host());
    }

    public void initialize() {
        LOG.info("Trying to start the Microprofile LRA container");
        this.container.start();
        this.registerProperties();
        LOG.info("Microprofile LRA instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Microprofile LRA container");
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    @Override
    public String host() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getMappedPort(8080);
    }

    @Override
    public String callbackHost() {
        Network bridgeNetwork = this.container.getDockerClient().inspectNetworkCmd().withNetworkId("bridge").exec();
        String networkGateway = bridgeNetwork.getIpam().getConfig().stream().filter(config -> config.getGateway() != null).findAny().map(Network.Ipam.Config::getGateway).orElseThrow(() -> new IllegalStateException("Gateway cannot be found in the bridge network"));
        return networkGateway;
    }
}

