/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.keycloak.services;

import org.apache.camel.test.infra.keycloak.services.KeycloakInfraService;
import org.keycloak.admin.client.Keycloak;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakRemoteInfraService
implements KeycloakInfraService {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakRemoteInfraService.class);
    private final String keycloakServerUrl;
    private final String keycloakRealm;
    private final String keycloakUsername;
    private final String keycloakPassword;

    public KeycloakRemoteInfraService() {
        this(System.getProperty("keycloak.server.url"), System.getProperty("keycloak.realm", "master"), System.getProperty("keycloak.username"), System.getProperty("keycloak.password"));
    }

    public KeycloakRemoteInfraService(String keycloakServerUrl, String keycloakRealm, String keycloakUsername, String keycloakPassword) {
        this.keycloakServerUrl = keycloakServerUrl;
        this.keycloakRealm = keycloakRealm;
        this.keycloakUsername = keycloakUsername;
        this.keycloakPassword = keycloakPassword;
    }

    public void registerProperties() {
        System.setProperty("keycloak.server.url", this.getKeycloakServerUrl());
        System.setProperty("keycloak.realm", this.getKeycloakRealm());
        System.setProperty("keycloak.username", this.getKeycloakUsername());
        System.setProperty("keycloak.password", this.getKeycloakPassword());
    }

    public void initialize() {
        LOG.info("Using remote Keycloak instance at {}", (Object)this.getKeycloakServerUrl());
        this.registerProperties();
    }

    public void shutdown() {
        LOG.info("Remote Keycloak service shutdown (no-op)");
    }

    @Override
    public String getKeycloakServerUrl() {
        return this.keycloakServerUrl;
    }

    @Override
    public String getKeycloakRealm() {
        return this.keycloakRealm;
    }

    @Override
    public String getKeycloakUsername() {
        return this.keycloakUsername;
    }

    @Override
    public String getKeycloakPassword() {
        return this.keycloakPassword;
    }

    @Override
    public Keycloak getKeycloakAdminClient() {
        return Keycloak.getInstance((String)this.getKeycloakServerUrl(), (String)this.getKeycloakRealm(), (String)this.getKeycloakUsername(), (String)this.getKeycloakPassword(), (String)"admin-cli");
    }
}

