/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.keycloak.services;

import java.time.Duration;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.keycloak.services.KeycloakInfraService;
import org.keycloak.admin.client.Keycloak;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=KeycloakInfraService.class, description="Identity and access management solution", serviceAlias={"keycloak"})
public class KeycloakLocalContainerInfraService
implements KeycloakInfraService,
ContainerService<GenericContainer<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakLocalContainerInfraService.class);
    private static final String DEFAULT_KEYCLOAK_CONTAINER = "quay.io/keycloak/keycloak:latest";
    private static final int KEYCLOAK_PORT = 8080;
    private static final String DEFAULT_ADMIN_USERNAME = "admin";
    private static final String DEFAULT_ADMIN_PASSWORD = "admin";
    private static final String DEFAULT_REALM = "master";
    private final GenericContainer<?> container;

    public KeycloakLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(KeycloakLocalContainerInfraService.class, (String)"keycloak.container"));
    }

    public KeycloakLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public KeycloakLocalContainerInfraService(GenericContainer<?> container) {
        this.container = container;
    }

    protected GenericContainer<?> initContainer(String imageName) {
        final String keycloakImage = imageName != null ? imageName : DEFAULT_KEYCLOAK_CONTAINER;
        class TestInfraKeycloakContainer
        extends GenericContainer<TestInfraKeycloakContainer> {
            public TestInfraKeycloakContainer(boolean fixedPort) {
                super(DockerImageName.parse((String)string));
                ((TestInfraKeycloakContainer)((TestInfraKeycloakContainer)((TestInfraKeycloakContainer)((TestInfraKeycloakContainer)((TestInfraKeycloakContainer)this.withExposedPorts(new Integer[]{8080})).withEnv("KEYCLOAK_ADMIN", "admin")).withEnv("KEYCLOAK_ADMIN_PASSWORD", "admin")).withCommand("start-dev")).waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{8080}))).withStartupTimeout(Duration.ofMinutes(3L));
                if (fixedPort) {
                    this.addFixedExposedPort(8080, 8080);
                }
            }
        }
        return new TestInfraKeycloakContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("keycloak.server.url", this.getKeycloakServerUrl());
        System.setProperty("keycloak.realm", this.getKeycloakRealm());
        System.setProperty("keycloak.username", this.getKeycloakUsername());
        System.setProperty("keycloak.password", this.getKeycloakPassword());
    }

    public void initialize() {
        LOG.info("Trying to start the Keycloak container");
        this.container.start();
        this.registerProperties();
        LOG.info("Keycloak instance running at {}", (Object)this.getKeycloakServerUrl());
        LOG.info("Keycloak admin console available at {}/admin", (Object)this.getKeycloakServerUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the Keycloak container");
        this.container.stop();
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    @Override
    public String getKeycloakServerUrl() {
        return String.format("http://%s:%d", this.container.getHost(), this.container.getMappedPort(8080));
    }

    @Override
    public String getKeycloakRealm() {
        return DEFAULT_REALM;
    }

    @Override
    public String getKeycloakUsername() {
        return "admin";
    }

    @Override
    public String getKeycloakPassword() {
        return "admin";
    }

    @Override
    public Keycloak getKeycloakAdminClient() {
        return Keycloak.getInstance((String)this.getKeycloakServerUrl(), (String)this.getKeycloakRealm(), (String)this.getKeycloakUsername(), (String)this.getKeycloakPassword(), (String)"admin-cli");
    }
}

