/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import com.github.dockerjava.api.command.CreateContainerCmd;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class StrimziContainer
extends GenericContainer<StrimziContainer> {
    static final String STRIMZI_CONTAINER = LocalPropertyResolver.getProperty(StrimziContainer.class, (String)"strimzi.container.image");
    private static final int KAFKA_PORT = 9092;

    public StrimziContainer(Network network, String name, String zookeeperInstanceName) {
        this(network, name, STRIMZI_CONTAINER, zookeeperInstanceName);
    }

    public StrimziContainer(Network network, String name, String containerName, String zookeeperInstanceName) {
        super(containerName);
        ((StrimziContainer)((StrimziContainer)((StrimziContainer)((StrimziContainer)((StrimziContainer)((StrimziContainer)((StrimziContainer)((StrimziContainer)this.withEnv("LOG_DIR", "/tmp/logs")).withExposedPorts(new Integer[]{9092})).withEnv("KAFKA_ADVERTISED_LISTENERS", String.format("PLAINTEXT://%s:9092", this.getHost()))).withEnv("KAFKA_LISTENERS", "PLAINTEXT://0.0.0.0:9092")).withEnv("KAFKA_ZOOKEEPER_CONNECT", zookeeperInstanceName + ":2181")).withNetwork(network)).withCreateContainerCmdModifier(createContainerCmd -> this.setupContainer(name, (CreateContainerCmd)createContainerCmd))).withCommand(new String[]{"sh", "-c", "bin/kafka-server-start.sh config/server.properties --override listeners=${KAFKA_LISTENERS} --override advertised.listeners=${KAFKA_ADVERTISED_LISTENERS} --override zookeeper.connect=${KAFKA_ZOOKEEPER_CONNECT}"})).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    private void setupContainer(String name, CreateContainerCmd createContainerCmd) {
        createContainerCmd.withHostName(name);
    }

    public int getKafkaPort() {
        return this.getMappedPort(9092);
    }

    public void start() {
        this.addFixedExposedPort(9092, 9092);
        super.start();
    }
}

