/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import com.github.dockerjava.api.command.CreateContainerCmd;
import java.util.UUID;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class ConfluentContainer
extends GenericContainer<ConfluentContainer> {
    static final String CONFLUENT_CONTAINER = LocalPropertyResolver.getProperty(ConfluentContainer.class, (String)"confluent.container.image");
    private static final int KAFKA_PORT = 9092;

    public ConfluentContainer(Network network, String name) {
        this(network, name, CONFLUENT_CONTAINER);
    }

    public ConfluentContainer(Network network, String name, String containerName) {
        super(containerName);
        ((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)((ConfluentContainer)this.withEnv("LOG_DIR", "/tmp/logs")).withExposedPorts(new Integer[]{9092})).withEnv("KAFKA_BROKER_ID", "1")).withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "BROKER:PLAINTEXT,PLAINTEXT:PLAINTEXT,CONTROLLER:PLAINTEXT")).withEnv("KAFKA_ADVERTISED_LISTENERS", String.format("PLAINTEXT://%s:9092,BROKER://%s:9093", this.getHost(), this.getHost()))).withEnv("KAFKA_GROUP_INITIAL_REBALANCE_DELAY_MS", "0")).withEnv("KAFKA_TRANSACTION_STATE_LOG_MIN_ISR", "1")).withEnv("KAFKA_TRANSACTION_STATE_LOG_REPLICATION_FACTOR", "1")).withEnv("KAFKA_OFFSETS_TOPIC_REPLICATION_FACTOR", "1")).withEnv("KAFKA_PROCESS_ROLES", "broker,controller")).withEnv("KAFKA_NODE_ID", "1")).withEnv("KAFKA_CONTROLLER_QUORUM_VOTERS", "1@0.0.0.0:9094")).withEnv("KAFKA_LISTENERS", "PLAINTEXT://0.0.0.0:9092,BROKER://0.0.0.0:9093,CONTROLLER://0.0.0.0:9094")).withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER")).withEnv("KAFKA_CONTROLLER_LISTENER_NAMES", "CONTROLLER")).withEnv("KAFKA_LOG_DIRS", "/tmp/kraft-combined-logs")).withEnv("KAFKA_REST_HOST_NAME", "rest-proxy")).withEnv("KAFKA_REST_LISTENERS", String.format("http://%s:9092", this.getHost()))).withEnv("KAFKA_REST_BOOTSTRAP_SERVERS", "localhost:9092")).withEnv("PATH", "PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin")).withEnv("container", "oci")).withEnv("LANG", "C.UTF-8")).withEnv("UB_CLASSPATH", "/usr/share/java/cp-base-lite/*")).withEnv("KAFKA_ZOOKEEPER_CONNECT", "")).withEnv("CLUSTER_ID", UUID.randomUUID().toString().replace("-", "").substring(0, 22))).withNetwork(network)).withCreateContainerCmdModifier(createContainerCmd -> this.setupContainer(name, (CreateContainerCmd)createContainerCmd))).withCommand(new String[]{"sh", "-c", "/etc/confluent/docker/run"})).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Kafka Server started.*", (int)1));
    }

    private void setupContainer(String name, CreateContainerCmd createContainerCmd) {
        createContainerCmd.withHostName(name);
        createContainerCmd.withName(name);
    }

    public int getKafkaPort() {
        return this.getMappedPort(9092);
    }

    public void start() {
        this.addFixedExposedPort(9092, 9092);
        super.start();
    }
}

