/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.TestUtils;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.kafka.services.KafkaInfraService;
import org.apache.camel.test.infra.kafka.services.RedpandaTransactionsEnabledContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.redpanda.RedpandaContainer;

@InfraService(service=KafkaInfraService.class, description="Apache Kafka, Distributed event streaming platform", serviceAlias={"kafka"}, serviceImplementationAlias={"redpanda"})
public class RedpandaInfraService
implements KafkaInfraService,
ContainerService<RedpandaContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(RedpandaInfraService.class);
    private final RedpandaContainer redpandaContainer;

    public RedpandaInfraService() {
        this("redpanda-" + TestUtils.randomWithRange((int)1, (int)100));
    }

    public RedpandaInfraService(String redpandaInstanceName) {
        Network network = Network.newNetwork();
        this.redpandaContainer = this.initRedpandaContainer(network, redpandaInstanceName);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.redpandaContainer.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public RedpandaInfraService(RedpandaContainer redpandaContainer) {
        this.redpandaContainer = redpandaContainer;
    }

    protected RedpandaContainer initRedpandaContainer(Network network, String instanceName) {
        return new RedpandaTransactionsEnabledContainer(RedpandaTransactionsEnabledContainer.REDPANDA_CONTAINER);
    }

    protected Integer getKafkaPort() {
        return this.redpandaContainer.getMappedPort(9092);
    }

    @Override
    public String getBootstrapServers() {
        return this.redpandaContainer.getHost() + ":" + this.getKafkaPort();
    }

    @Override
    public String brokers() {
        return this.getBootstrapServers();
    }

    public void registerProperties() {
        System.setProperty("kafka.bootstrap.servers", this.getBootstrapServers());
    }

    public void initialize() {
        this.redpandaContainer.start();
        this.registerProperties();
        LOG.info("Redpanda bootstrap server running at address {}", (Object)this.getBootstrapServers());
    }

    private boolean stopped() {
        return !this.redpandaContainer.isRunning();
    }

    public void shutdown() {
        LOG.info("Stopping Redpanda container");
        this.redpandaContainer.stop();
    }

    public RedpandaContainer getContainer() {
        return this.redpandaContainer;
    }
}

