/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.kafka.services.ContainerLocalKafkaInfraService;
import org.apache.camel.test.infra.kafka.services.KafkaService;
import org.apache.camel.test.infra.kafka.services.RedpandaInfraService;
import org.apache.camel.test.infra.kafka.services.RemoteKafkaInfraService;
import org.apache.camel.test.infra.kafka.services.StrimziInfraService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.kafka.KafkaContainer;
import org.testcontainers.utility.DockerImageName;

public final class KafkaServiceFactory {
    private KafkaServiceFactory() {
    }

    public static SimpleTestServiceBuilder<KafkaService> builder() {
        return new SimpleTestServiceBuilder("kafka");
    }

    public static KafkaService createService() {
        SimpleTestServiceBuilder builder = new SimpleTestServiceBuilder("kafka");
        return (KafkaService)builder.addLocalMapping(ContainerLocalKafkaService::kafka3Container).addMapping("local-strimzi-container", StrimziService::new).addRemoteMapping(RemoteKafkaService::new).addMapping("local-kafka3-container", ContainerLocalKafkaService::kafka3Container).addMapping("local-redpanda-container", RedpandaService::new).build();
    }

    public static KafkaService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final KafkaService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<KafkaService> instance = KafkaServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonKafkaService(ContainerLocalKafkaService.kafka3Container(), "kafka")).addRemoteMapping(RemoteKafkaService::new).addMapping("local-kafka3-container", () -> new SingletonKafkaService(ContainerLocalKafkaService.kafka3Container(), "kafka3")).addMapping("local-strimzi-container", () -> new SingletonKafkaService(new StrimziService(), "strimzi")).addMapping("local-redpanda-container", () -> new SingletonKafkaService(new RedpandaService(), "redpanda"));
            INSTANCE = (KafkaService)instance.build();
        }
    }

    public static class RemoteKafkaService
    extends RemoteKafkaInfraService
    implements KafkaService {
    }

    public static class RedpandaService
    extends RedpandaInfraService
    implements KafkaService {
    }

    public static class StrimziService
    extends StrimziInfraService
    implements KafkaService {
    }

    public static class ContainerLocalKafkaService
    extends ContainerLocalKafkaInfraService
    implements KafkaService {
        public ContainerLocalKafkaService(KafkaContainer kafka) {
            this.kafka = kafka;
        }

        public static ContainerLocalKafkaService kafka3Container() {
            KafkaContainer container = new KafkaContainer(DockerImageName.parse((String)System.getProperty("kafka.container", KAFKA3_IMAGE_NAME)).asCompatibleSubstituteFor("apache/kafka"));
            return new ContainerLocalKafkaService(container);
        }
    }

    static class SingletonKafkaService
    extends SingletonService<KafkaService>
    implements KafkaService {
        public SingletonKafkaService(KafkaService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public String getBootstrapServers() {
            return ((KafkaService)this.getService()).getBootstrapServers();
        }

        public final void beforeAll(ExtensionContext extensionContext) {
            super.beforeAll(extensionContext);
        }

        public final void afterAll(ExtensionContext extensionContext) {
        }
    }
}

