/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.kafka.services.KafkaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class ContainerLocalAuthKafkaService
implements KafkaService,
ContainerService<KafkaContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerLocalAuthKafkaService.class);
    private final KafkaContainer kafka;

    public ContainerLocalAuthKafkaService(String jaasConfigFile) {
        this.kafka = this.initContainer(jaasConfigFile);
    }

    public ContainerLocalAuthKafkaService(KafkaContainer kafka) {
        this.kafka = kafka;
    }

    protected KafkaContainer initContainer(String jaasConfigFile) {
        return new TransientAuthenticatedKafkaContainer(jaasConfigFile);
    }

    @Override
    public String getBootstrapServers() {
        return this.kafka.getBootstrapServers();
    }

    public void registerProperties() {
        System.setProperty("kafka.bootstrap.servers", this.getBootstrapServers());
    }

    public void initialize() {
        this.kafka.start();
        this.registerProperties();
        LOG.info("Kafka bootstrap server running at address {}", (Object)this.kafka.getBootstrapServers());
    }

    public void shutdown() {
        this.kafka.stop();
    }

    public KafkaContainer getContainer() {
        return this.kafka;
    }

    public static String generateSimpleSaslJaasConfig(String username, String password) {
        return String.format("org.apache.kafka.common.security.plain.PlainLoginModule required username='%s' password='%s';", username, password);
    }

    public static class StaticKafkaContainer
    extends TransientAuthenticatedKafkaContainer {
        public StaticKafkaContainer(String jaasConfigFile) {
            super(jaasConfigFile);
            this.addFixedExposedPort(9093, 9093);
        }

        public String getBootstrapServers() {
            return String.format("PLAINTEXT://%s:9093", this.getHost());
        }
    }

    public static class TransientAuthenticatedKafkaContainer
    extends KafkaContainer {
        public TransientAuthenticatedKafkaContainer(String jaasConfigFile) {
            super(DockerImageName.parse((String)"confluentinc/cp-kafka:7.3.1"));
            this.withEmbeddedZookeeper();
            MountableFile mountableFile = MountableFile.forClasspathResource((String)jaasConfigFile);
            LOG.debug("Using mountable file at: {}", (Object)mountableFile.getFilesystemPath());
            this.withCopyFileToContainer(mountableFile, "/tmp/kafka-jaas.config");
            ((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)this.withEnv("KAFKA_OPTS", "-Djava.security.auth.login.config=/tmp/kafka-jaas.config")).withEnv("KAFKA_LISTENERS", "PLAINTEXT://0.0.0.0:9093,BROKER://0.0.0.0:9092")).withEnv("KAFKA_SASL_MECHANISM_INTER_BROKER_PROTOCOL", "PLAIN")).withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "PLAINTEXT:SASL_PLAINTEXT,BROKER:PLAINTEXT")).withEnv("KAFKA_SASL_ENABLED_MECHANISMS", "PLAIN");
        }
    }
}

