/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.ibmmq.services;

import java.util.function.Consumer;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.ibmmq.services.IbmMQInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=IbmMQInfraService.class, description="IBM MQ messaging middleware", serviceAlias={"ibmmq"})
public class IbmMQLocalContainerInfraService
implements IbmMQInfraService,
ContainerService<GenericContainer<?>> {
    public static final String CONTAINER_NAME = "ibmmq";
    public static final int MQ_LISTENER_PORT = 1414;
    public static final int WEB_CONSOLE_PORT = 9443;
    private static final Logger LOG = LoggerFactory.getLogger(IbmMQLocalContainerInfraService.class);
    private final GenericContainer<?> container;

    public IbmMQLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(IbmMQLocalContainerInfraService.class, (String)"ibm.mq.container"));
    }

    public IbmMQLocalContainerInfraService(String containerImage) {
        this.container = this.initContainer(containerImage);
    }

    protected GenericContainer<?> initContainer(final String imageName) {
        class IbmMQContainer
        extends GenericContainer<IbmMQContainer> {
            public IbmMQContainer() {
                super(DockerImageName.parse((String)string));
                ((IbmMQContainer)((IbmMQContainer)((IbmMQContainer)((IbmMQContainer)this.withNetworkAliases(new String[]{IbmMQLocalContainerInfraService.CONTAINER_NAME})).withEnv("LICENSE", "accept")).withEnv("MQ_QMGR_NAME", "QM1")).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG))).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Queued Publish/Subscribe Daemon started for queue manager.*", (int)1));
                this.addFixedExposedPort(1414, 1414);
                this.addFixedExposedPort(9443, 9443);
            }
        }
        return new IbmMQContainer();
    }

    public void registerProperties() {
        System.setProperty("ibm.mq.channel", this.channel());
        System.setProperty("ibm.mq.qmgr.name", this.queueManager());
        System.setProperty("ibm.mq.port", String.valueOf(this.listenerPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the IBM MQ container");
        this.container.withStartupAttempts(5);
        this.container.start();
        this.registerProperties();
    }

    public void shutdown() {
        LOG.info("Stopping the IBM MQ container");
        this.container.stop();
        System.clearProperty("ibm.mq.channel");
        System.clearProperty("ibm.mq.qmgr.name");
        System.clearProperty("ibm.mq.port");
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    @Override
    public String channel() {
        return "DEV.APP.SVRCONN";
    }

    @Override
    public String queueManager() {
        return "QM1";
    }

    @Override
    public int listenerPort() {
        return 1414;
    }
}

