/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.hivemq.services;

import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.hivemq.services.HiveMQInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.hivemq.HiveMQContainer;

public abstract class AbstractLocalHiveMQService<T extends AbstractLocalHiveMQService<T>>
implements HiveMQInfraService,
ContainerService<HiveMQContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLocalHiveMQService.class);
    public static final int MQTT_PORT_DEFAULT = 1883;
    public static final int WEBSOCKET_PORT_DEFAULT = 8000;
    private final HiveMQContainer container;

    protected abstract HiveMQContainer initContainer(String var1);

    protected AbstractLocalHiveMQService(String imageName) {
        this.container = (HiveMQContainer)((HiveMQContainer)this.initContainer(imageName).withExposedPorts(new Integer[]{1883, 8000})).waitingFor((WaitStrategy)Wait.forListeningPort());
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    @Override
    public int getMqttPort() {
        return this.container.getMqttPort();
    }

    @Override
    public String getMqttHost() {
        return this.container.getHost();
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public char[] getUserPassword() {
        return null;
    }

    public void registerProperties() {
        System.setProperty("hivemq.service.mqtt.host", this.getMqttHost());
        System.setProperty("hivemq.service.mqtt.port", String.valueOf(this.getMqttPort()));
        System.setProperty("hivemq.service.mqtt.hostaddress", this.getMqttHostAddress());
    }

    public void initialize() {
        LOG.info("Starting the HiveMQ container");
        this.container.start();
        this.registerProperties();
        LOG.info("HiveMQ instance running at {}", (Object)this.getMqttHostAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the HiveMQ container");
        this.container.stop();
    }

    public void close() {
        this.shutdown();
    }

    @Override
    public boolean isRunning() {
        return this.container.isRunning();
    }

    public HiveMQContainer getContainer() {
        return this.container;
    }
}

