/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.hivemq.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.hivemq.services.AbstractLocalHiveMQService;
import org.apache.camel.test.infra.hivemq.services.HiveMQInfraService;
import org.testcontainers.hivemq.HiveMQContainer;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=HiveMQInfraService.class, description="MQTT Platform HiveMQ", serviceAlias={"hive-mq"}, serviceImplementationAlias={"sparkplug"})
public class LocalHiveMQSparkplugTCKInfraService
extends AbstractLocalHiveMQService<LocalHiveMQSparkplugTCKInfraService> {
    LocalHiveMQSparkplugTCKInfraService() {
        super(LocalPropertyResolver.getProperty(LocalHiveMQSparkplugTCKInfraService.class, (String)"hivemq.sparkplug.container"));
    }

    @Override
    protected HiveMQContainer initContainer(String imageName) {
        String dockerfileResourcePath = LocalPropertyResolver.getProperty(LocalHiveMQSparkplugTCKInfraService.class, (String)"hivemq.resource.path");
        ImageFromDockerfile newImage = (ImageFromDockerfile)new ImageFromDockerfile(imageName, false).withFileFromClasspath(".", dockerfileResourcePath);
        String newImageName = (String)newImage.get();
        HiveMQContainer newContainer = new HiveMQContainer(DockerImageName.parse((String)newImageName).asCompatibleSubstituteFor("hivemq/hivemq-ce"));
        return newContainer;
    }
}

