/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.fhir.services;

import java.time.Duration;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.fhir.services.FhirInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@InfraService(service=FhirInfraService.class, description="HAPI FHIR RESTful test server", serviceAlias={"fhir"})
public class FhirLocalContainerInfraService
implements FhirInfraService,
ContainerService<GenericContainer<?>> {
    public static final String CONTAINER_NAME = "fhir";
    private static final Logger LOG = LoggerFactory.getLogger(FhirLocalContainerInfraService.class);
    private final GenericContainer<?> container;

    public FhirLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(FhirLocalContainerInfraService.class, (String)"fhir.container"));
    }

    public FhirLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName, CONTAINER_NAME);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public FhirLocalContainerInfraService(GenericContainer<?> container) {
        this.container = container;
    }

    protected GenericContainer<?> initContainer(final String imageName, final String containerName) {
        class FhirContainer
        extends GenericContainer<FhirContainer> {
            public FhirContainer(boolean fixedPort) {
                super(string);
                this.withNetworkAliases(new String[]{containerName});
                if (fixedPort) {
                    this.addFixedExposedPort(8080, 8080);
                } else {
                    this.withExposedPorts(new Integer[]{8080});
                }
                this.withStartupTimeout(Duration.ofMinutes(3L));
                this.withStartupAttempts(5);
                this.withEnv("hapi.fhir.allow_multiple_delete", "true");
                this.withEnv("hapi.fhir.fhir_version", "R4");
                this.withEnv("hapi.fhir.reuse_cached_search_results_millis", "-1");
                this.waitingFor((WaitStrategy)Wait.forListeningPort());
                this.waitingFor(Wait.forHttp((String)"/fhir/metadata").withStartupTimeout(Duration.ofMinutes(3L)));
            }
        }
        return new FhirContainer(ContainerEnvironmentUtil.isFixedPort(this.getClass()));
    }

    public void registerProperties() {
        System.setProperty("fhir.service.base.url", this.getServiceBaseURL());
        System.setProperty("fhir.service.host", this.getHost());
        System.setProperty("fhir.service.port", String.valueOf(this.getPort()));
    }

    public void initialize() {
        LOG.info("Trying to start the FHIR container");
        this.container.start();
        this.registerProperties();
        LOG.info("FHIR instance running at {}", (Object)this.getServiceBaseURL());
    }

    public void shutdown() {
        LOG.info("Stopping the FHIR container");
        this.container.stop();
    }

    public GenericContainer<?> getContainer() {
        return this.container;
    }

    @Override
    public String getServiceBaseURL() {
        return String.format("http://%s:%d/fhir", this.container.getHost(), this.container.getMappedPort(8080));
    }

    @Override
    public String getHost() {
        return this.container.getHost();
    }

    @Override
    public Integer getPort() {
        return this.container.getMappedPort(8080);
    }
}

