/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.couchbase.services;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.manager.view.DesignDocument;
import com.couchbase.client.java.manager.view.View;
import com.couchbase.client.java.view.DesignDocumentNamespace;
import java.util.Collections;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.couchbase.CouchbaseContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=CouchbaseInfraService.class, description="NoSQL database Couchbase", serviceAlias={"couchbase"})
public class CouchbaseLocalContainerInfraService
implements CouchbaseInfraService,
ContainerService<CouchbaseContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseLocalContainerInfraService.class);
    private final CouchbaseContainer container;

    public CouchbaseLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(CouchbaseLocalContainerInfraService.class, (String)"couchbase.container"));
    }

    public CouchbaseLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
        String name = ContainerEnvironmentUtil.containerName(this.getClass());
        if (name != null) {
            this.container.withCreateContainerCmdModifier(cmd -> cmd.withName(name));
        }
    }

    public CouchbaseLocalContainerInfraService(CouchbaseContainer container) {
        this.container = container;
    }

    protected CouchbaseContainer initContainer(String imageName) {
        return new CustomCouchbaseContainer(imageName);
    }

    @Override
    public String getConnectionString() {
        return this.container.getConnectionString();
    }

    @Override
    public String getUsername() {
        return this.username();
    }

    @Override
    public String getPassword() {
        return this.password();
    }

    @Override
    public String getHostname() {
        return this.hostname();
    }

    @Override
    public int getPort() {
        return this.port();
    }

    @Override
    public String protocol() {
        return "http";
    }

    @Override
    public String hostname() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getBootstrapHttpDirectPort();
    }

    @Override
    public String username() {
        return this.container.getUsername();
    }

    @Override
    public String password() {
        return this.container.getPassword();
    }

    @Override
    public String bucket() {
        String bucketName = "myBucket";
        Cluster cluster = Cluster.connect((String)this.getConnectionString(), (String)this.username(), (String)this.password());
        cluster.buckets().createBucket(BucketSettings.create((String)bucketName).bucketType(BucketType.COUCHBASE));
        DesignDocument designDoc = new DesignDocument(this.designDocumentName(), Collections.singletonMap(this.viewName(), new View("function (doc, meta) {  emit(meta.id, doc);}")));
        cluster.bucket(bucketName).viewIndexes().upsertDesignDocument(designDoc, DesignDocumentNamespace.PRODUCTION);
        return bucketName;
    }

    @Override
    public String viewName() {
        return "myView";
    }

    @Override
    public String designDocumentName() {
        return "myDesignDocument";
    }

    public void registerProperties() {
        System.setProperty("couchbase.hostname", this.getHostname());
        System.setProperty("couchbase.port", String.valueOf(this.getPort()));
        System.setProperty("couchbase.username", this.getUsername());
        System.setProperty("couchbase.password", this.getPassword());
    }

    public void initialize() {
        this.container.start();
        this.registerProperties();
        LOG.debug("Couchbase container running at {}", (Object)this.getConnectionString());
    }

    public void shutdown() {
        this.container.stop();
    }

    public CouchbaseContainer getContainer() {
        return this.container;
    }

    private class CustomCouchbaseContainer
    extends CouchbaseContainer {
        public CustomCouchbaseContainer(String imageName) {
            super(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor("couchbase/server"));
            int kvPort = 11210;
            this.addFixedExposedPort(11210, 11210);
            int managementPort = 8091;
            this.addFixedExposedPort(8091, 8091);
            int viewPort = 8092;
            this.addFixedExposedPort(8092, 8092);
            int queryPort = 8093;
            this.addFixedExposedPort(8093, 8093);
            int searchPort = 8094;
            this.addFixedExposedPort(8094, 8094);
        }
    }
}

