/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common.services;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.common.services.TestServiceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTestServiceBuilder<T extends TestService>
implements TestServiceBuilder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTestServiceBuilder.class);
    private final Map<String, Supplier<T>> mappings = new HashMap<String, Supplier<T>>();
    private final String name;
    private String propertyNameFormat = "%s.instance.type";

    public SimpleTestServiceBuilder(String name) {
        this.name = name;
    }

    public SimpleTestServiceBuilder<T> addMapping(String name, Supplier<T> supplier) {
        this.mappings.put(name, supplier);
        return this;
    }

    public SimpleTestServiceBuilder<T> addLocalMapping(Supplier<T> supplier) {
        this.mappings.put(this.localMappingKey(), supplier);
        return this;
    }

    public SimpleTestServiceBuilder<T> addRemoteMapping(Supplier<T> supplier) {
        this.mappings.put(this.remoteMappingKey(), supplier);
        return this;
    }

    public SimpleTestServiceBuilder<T> withPropertyNameFormat(String propertyNameFormat) {
        this.propertyNameFormat = propertyNameFormat;
        return this;
    }

    @Override
    public T build() {
        String defaultName = this.localMappingKey();
        String propertyName = String.format(this.propertyNameFormat, this.name);
        String instanceType = System.getProperty(propertyName, defaultName);
        Supplier<T> supplier = this.mappings.get(instanceType);
        if (supplier == null) {
            String valid = String.join((CharSequence)", ", this.mappings.keySet());
            LOG.error("Invalid instance type: {}. Must one of: {}", (Object)instanceType, (Object)valid);
            throw new UnsupportedOperationException("Invalid instance type: " + instanceType);
        }
        return (T)((TestService)supplier.get());
    }

    private String localMappingKey() {
        return String.format("local-%s-container", this.name);
    }

    private String remoteMappingKey() {
        return "remote";
    }
}

