/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common.services;

import org.apache.camel.test.infra.common.services.TestService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestServiceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TestServiceUtil.class);

    private TestServiceUtil() {
    }

    public static void tryInitialize(TestService service, ExtensionContext extensionContext) throws Exception {
        try {
            service.initialize();
        }
        catch (Exception e) {
            TestServiceUtil.logAndRethrow(service, extensionContext, e);
        }
    }

    public static void tryShutdown(TestService service, ExtensionContext extensionContext) throws Exception {
        try {
            service.shutdown();
        }
        catch (Exception e) {
            TestServiceUtil.logAndRethrow(service, extensionContext, e);
        }
    }

    public static void logAndRethrow(TestService service, ExtensionContext extensionContext, Exception exception) throws Exception {
        Object o = extensionContext.getTestInstance().get();
        LOG.error("Failed to initialize service {} for test {} on ({})", new Object[]{service.getClass().getSimpleName(), extensionContext.getDisplayName(), o.getClass().getName()});
        throw exception;
    }
}

