/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common.services;

import org.apache.camel.test.infra.common.services.TestService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonService<T extends TestService>
implements ExtensionContext.Store.CloseableResource,
TestService {
    private static final Logger LOG = LoggerFactory.getLogger(SingletonService.class);
    private final T service;
    private final String name;

    public SingletonService(T service, String name) {
        this.service = service;
        this.name = name;
    }

    protected void addToStore(ExtensionContext extensionContext) {
        ExtensionContext root = extensionContext.getRoot();
        LOG.debug("Using root: {}", (Object)root);
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        LOG.debug("Using store: {}", (Object)store);
        store.getOrComputeIfAbsent((Object)this.name, this::doInitializeService);
    }

    protected SingletonService<T> doInitializeService(String name) {
        LOG.debug("Registering singleton service {}", (Object)name);
        this.service.initialize();
        return this;
    }

    @Override
    public void beforeAll(ExtensionContext extensionContext) {
        this.addToStore(extensionContext);
    }

    @Override
    public void afterAll(ExtensionContext extensionContext) {
    }

    @Override
    public void registerProperties() {
        this.service.registerProperties();
    }

    @Override
    public void initialize() {
        this.service.initialize();
    }

    @Override
    public void shutdown() {
        this.service.shutdown();
    }

    @Override
    public void close() {
        this.service.shutdown();
    }

    protected T getService() {
        return this.service;
    }
}

