/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.utility.TestcontainersConfiguration;

public final class TestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestUtils.class);

    private TestUtils() {
    }

    public static <T> boolean waitFor(Predicate<T> resourceCheck, T payload) {
        boolean state = false;
        int retries = 30;
        int waitTime = 1000;
        do {
            try {
                state = resourceCheck.test(payload);
                if (state) continue;
                LOG.debug("The resource is not yet available. Waiting {} seconds before retrying", (Object)TimeUnit.MILLISECONDS.toSeconds(waitTime));
                --retries;
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (!state && retries > 0);
        return state;
    }

    public static boolean waitFor(BooleanSupplier resourceCheck) {
        boolean state = false;
        int retries = 30;
        int waitTime = 1000;
        do {
            try {
                state = resourceCheck.getAsBoolean();
                if (state) continue;
                LOG.debug("The resource is not yet available. Waiting {} seconds before retrying", (Object)TimeUnit.MILLISECONDS.toSeconds(waitTime));
                --retries;
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (!state && retries > 0);
        return state;
    }

    public static int randomWithRange(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max);
    }

    public static String prependHubImageNamePrefixIfNeeded(String imageName) {
        return TestcontainersConfiguration.getInstance().getEnvVarOrProperty("hub.image.name.prefix", "") + imageName;
    }
}

