/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.azure.storage.blob.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.azure.common.AzureCredentialsHolder;
import org.apache.camel.test.infra.azure.common.services.AzureInfraService;
import org.apache.camel.test.infra.azure.common.services.AzureStorageInfraService;

@InfraService(service=AzureInfraService.class, description="Local Azure services with Azurite", serviceAlias={"azure"}, serviceImplementationAlias={"storage-blob"})
public class AzureStorageBlobLocalContainerInfraService
extends AzureStorageInfraService {
    public void registerProperties() {
        super.registerProperties();
        System.setProperty("azure.storage.port", String.valueOf(this.getContainer().getMappedPort(10000)));
    }

    public AzureCredentialsHolder azureCredentials() {
        return this.getContainer().azureCredentials();
    }

    public String host() {
        return this.getContainer().getHost();
    }

    public int port() {
        return this.getContainer().getMappedPort(10000);
    }

    public String accountName() {
        return this.getContainer().azureCredentials().accountName();
    }

    public String accessKey() {
        return this.getContainer().azureCredentials().accountKey();
    }
}

