/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.messaging.services.MessagingContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class ArtemisContainer
extends GenericContainer<ArtemisContainer>
implements MessagingContainer {
    private static final int DEFAULT_MQTT_PORT = 1883;
    private static final int DEFAULT_AMQP_PORT = 5672;
    private static final int DEFAULT_ADMIN_PORT = 8161;
    private static final int DEFAULT_ACCEPTOR_PORT = 61616;
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "admin";

    public ArtemisContainer() {
        super(DockerImageName.parse((String)LocalPropertyResolver.getProperty(ArtemisContainer.class, (String)"artemis.container")));
        ((ArtemisContainer)((ArtemisContainer)((ArtemisContainer)((ArtemisContainer)this.withEnv("AMQ_EXTRA_ARGS", "--relax-jolokia")).withEnv("AMQ_USER", "admin")).withEnv("AMQ_PASSWORD", "admin")).withExposedPorts(new Integer[]{1883, 5672, 8161, 61616})).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public static ArtemisContainer withFixedPort() {
        ArtemisContainer container = new ArtemisContainer();
        container.addFixedExposedPort(1883, 1883);
        container.addFixedExposedPort(5672, 5672);
        container.addFixedExposedPort(8161, 8161);
        container.addFixedExposedPort(61616, 61616);
        return container;
    }

    public int amqpPort() {
        return this.getMappedPort(5672);
    }

    public String amqpEndpoint() {
        return String.format("amqp://%s:%d", this.getHost(), this.amqpPort());
    }

    public int mqttPort() {
        return this.getMappedPort(1883);
    }

    public String mqttEndpoint() {
        return String.format("tcp://%s:%d", this.getHost(), this.mqttPort());
    }

    public int adminPort() {
        return this.getMappedPort(8161);
    }

    public String adminURL() {
        return String.format("http://%s:%d", this.getHost(), this.adminPort());
    }

    public int defaultAcceptorPort() {
        return this.getMappedPort(61616);
    }

    public String defaultEndpoint() {
        return String.format("tcp://%s:%d", this.getHost(), this.defaultAcceptorPort());
    }

    public int openwirePort() {
        return this.defaultAcceptorPort();
    }

    public String getOpenwireEndpoint() {
        return String.format("tcp://%s:%d", this.getHost(), this.openwirePort());
    }

    public String username() {
        return "admin";
    }

    public String password() {
        return "admin";
    }
}

