/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.camel.test.infra.artemis.common.ArtemisRunException;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;

public class ArtemisMQTTInfraService
extends AbstractArtemisEmbeddedService {
    private String brokerURL;
    private int port;

    public ArtemisMQTTInfraService(int port) {
        super(port);
    }

    public ArtemisMQTTInfraService() {
    }

    @Override
    protected Configuration configure(Configuration configuration, int port, int brokerId) {
        this.port = port;
        this.brokerURL = "tcp://0.0.0.0:" + port;
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        try {
            configuration.addAcceptorConfiguration("mqtt", this.brokerURL + "?protocols=MQTT");
            configuration.addAddressSetting("#", addressSettings);
            configuration.setMaxDiskUsage(98);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new ArtemisRunException("mqtt acceptor cannot be configured", e);
        }
        return configuration;
    }

    @Override
    public String serviceAddress() {
        return this.brokerURL;
    }

    @Override
    public String remoteURI() {
        return this.brokerURL;
    }

    @Override
    public int brokerPort() {
        return this.port;
    }
}

