/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.artemis.services.ArtemisContainer;
import org.apache.camel.test.infra.artemis.services.ArtemisInfraService;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InfraService(service=ArtemisInfraService.class, description="Apache Artemis is an open source message broker", serviceAlias={"artemis"})
public class ArtemisAllInfraService
implements ArtemisInfraService,
ContainerService<ArtemisContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ArtemisAllInfraService.class);
    private final ArtemisContainer container = this.initContainer();

    protected ArtemisContainer initContainer() {
        return ArtemisContainer.withFixedPort();
    }

    @Override
    public String serviceAddress() {
        return "tcp://localhost:" + this.brokerPort();
    }

    @Override
    public String userName() {
        return "artemis";
    }

    @Override
    public String password() {
        return "artemis";
    }

    @Override
    public int brokerPort() {
        return this.container.getMappedPort(61616);
    }

    @Override
    public void restart() {
    }

    @Override
    public long countMessages(String queue) throws Exception {
        return 0L;
    }

    @Override
    public QueueQueryResult getQueueQueryResult(String queueQuery) throws Exception {
        return null;
    }

    public void initialize() {
        LOG.info("Trying to start the Artemis container");
        this.container.start();
        this.registerProperties();
        LOG.info("Artemis instance running at {}", (Object)this.serviceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the Artemis container");
        this.container.stop();
    }

    public ArtemisContainer getContainer() {
        return this.container;
    }

    @Override
    public String remoteURI() {
        return this.serviceAddress();
    }
}

