/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import java.util.HashSet;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.InVMLoginModule;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.artemis.common.ArtemisRunException;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;
import org.apache.camel.test.infra.artemis.services.ArtemisInfraService;

@InfraService(service=ArtemisInfraService.class, description="Apache Artemis is an open source message broker", serviceAlias={"artemis"}, serviceImplementationAlias={"amqp"})
public class ArtemisAMQPInfraService
extends AbstractArtemisEmbeddedService {
    private String brokerURL;
    private int amqpPort;

    @Override
    protected Configuration configure(Configuration artemisConfiguration, int port, int brokerId) {
        this.amqpPort = port;
        String sslEnabled = System.getProperty("artemis.ssl.enabled", "false");
        String keyStorePath = System.getProperty("artemis.ssl.keystore.path", "");
        String keyStorePassword = System.getProperty("artemis.ssl.keystore.password", "");
        String trustStorePath = System.getProperty("artemis.ssl.truststore.path", "");
        String trustStorePassword = System.getProperty("artemis.ssl.truststore.password", "");
        this.brokerURL = "tcp://0.0.0.0:" + this.amqpPort + "?tcpSendBufferSize=1048576;tcpReceiveBufferSize=1048576;protocols=AMQP;useEpoll=true;amqpCredits=1000;amqpMinCredits=300" + String.format(";sslEnabled=%s;keyStorePath=%s;keyStorePassword=%s;trustStorePath=%s;trustStorePassword=%s", sslEnabled, keyStorePath, keyStorePassword, trustStorePath, trustStorePassword);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        try {
            artemisConfiguration.addAcceptorConfiguration("amqp", this.brokerURL);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new ArtemisRunException("AMQP acceptor cannot be configured", e);
        }
        artemisConfiguration.setPersistenceEnabled(false);
        artemisConfiguration.addAddressesSetting("#", addressSettings);
        artemisConfiguration.setSecurityEnabled("true".equalsIgnoreCase(System.getProperty("artemis.authentication.enabled")));
        if (artemisConfiguration.isSecurityEnabled()) {
            SecurityConfiguration sc = new SecurityConfiguration();
            String user = System.getProperty("artemis.username", "camel");
            String pw = System.getProperty("artemis.password", "rider");
            sc.addUser(user, pw);
            sc.addRole(user, "ALLOW_ALL");
            ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager(InVMLoginModule.class.getName(), sc);
            this.embeddedBrokerService.setSecurityManager((ActiveMQSecurityManager)securityManager);
            String roleName = "ALLOW_ALL";
            Role role = new Role(roleName, true, true, true, true, true, true, true, true, true, true, false, false);
            HashSet<Role> roles = new HashSet<Role>();
            roles.add(role);
            artemisConfiguration.putSecurityRoles("#", roles);
        }
        artemisConfiguration.setMaxDiskUsage(98);
        CoreAddressConfiguration pingTopicConfig = new CoreAddressConfiguration();
        pingTopicConfig.setName("topic.ping");
        pingTopicConfig.addRoutingType(RoutingType.MULTICAST);
        artemisConfiguration.addAddressConfiguration(pingTopicConfig);
        return artemisConfiguration;
    }

    @Override
    public String serviceAddress() {
        return this.brokerURL;
    }

    @Override
    public String remoteURI() {
        return "amqp://0.0.0.0:" + this.amqpPort;
    }

    @Override
    public int brokerPort() {
        return this.amqpPort;
    }
}

