/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.artemis.common.ArtemisRunException;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;
import org.apache.camel.test.infra.artemis.services.ArtemisInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InfraService(service=ArtemisInfraService.class, description="Apache Artemis is an open source message broker", serviceAlias={"artemis"})
public class ArtemisVMInfraService
extends AbstractArtemisEmbeddedService {
    private static final Logger LOG = LoggerFactory.getLogger(ArtemisVMInfraService.class);
    private String brokerURL;

    public ArtemisVMInfraService() {
    }

    protected ArtemisVMInfraService(int port) {
        super(port);
    }

    @Override
    protected Configuration configure(Configuration configuration, int port, int brokerId) {
        this.brokerURL = "vm://" + brokerId;
        LOG.info("Creating a new Artemis VM-based broker");
        configuration.setPersistenceEnabled(false);
        configuration.setJournalMinFiles(10);
        configuration.setSecurityEnabled(false);
        try {
            configuration.addAcceptorConfiguration("in-vm", "vm://" + brokerId);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new ArtemisRunException("vm acceptor cannot be configured", e);
        }
        configuration.addAddressSetting("#", new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL).setAutoDeleteQueues(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"DLQ")).setExpiryAddress(SimpleString.of((String)"ExpiryQueue")));
        return configuration;
    }

    @Override
    public String serviceAddress() {
        return this.brokerURL;
    }

    @Override
    public int brokerPort() {
        return 0;
    }

    public static class ReusableArtemisVMService
    extends ArtemisVMInfraService {
        public ReusableArtemisVMService(int port) {
            super(port);
        }

        @Override
        protected int computeBrokerId() {
            return 0;
        }
    }
}

