/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.artemis.services;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.artemis.common.ArtemisRunException;
import org.apache.camel.test.infra.artemis.services.AbstractArtemisEmbeddedService;
import org.apache.camel.test.infra.artemis.services.ArtemisInfraService;

@InfraService(service=ArtemisInfraService.class, description="Apache Artemis is an open source message broker", serviceAlias={"artemis"}, serviceImplementationAlias={"persistent"})
public class ArtemisPersistentVMInfraService
extends AbstractArtemisEmbeddedService {
    private String brokerURL;

    @Override
    protected Configuration configure(Configuration configuration, int port, int brokerId) {
        this.brokerURL = "vm://" + brokerId;
        configuration.setPersistenceEnabled(true);
        configuration.setJournalType(JournalType.NIO);
        configuration.setMaxDiskUsage(98);
        try {
            configuration.addAcceptorConfiguration("in-vm", this.brokerURL);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new ArtemisRunException("vm acceptor cannot be configured", e);
        }
        configuration.addAddressSetting("#", new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL).setAutoDeleteQueues(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"DLQ")).setExpiryAddress(SimpleString.of((String)"ExpiryQueue")));
        return configuration;
    }

    @Override
    public String serviceAddress() {
        return this.brokerURL;
    }

    @Override
    public int brokerPort() {
        return 0;
    }
}

