/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.arangodb.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.arangodb.services.ArangoDBInfraService;
import org.apache.camel.test.infra.arangodb.services.ArangoDbContainer;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerEnvironmentUtil;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

@InfraService(service=ArangoDBInfraService.class, description="ArangoDB is a multi-model database for high-performance applications.", serviceAlias={"arangodb"})
public class ArangoDBLocalContainerInfraService
implements ArangoDBInfraService,
ContainerService<ArangoDbContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(ArangoDBLocalContainerInfraService.class);
    private final ArangoDbContainer container;

    public ArangoDBLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(ArangoDBLocalContainerInfraService.class, (String)"arangodb.container"));
    }

    public ArangoDBLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public ArangoDBLocalContainerInfraService(ArangoDbContainer container) {
        this.container = container;
    }

    protected ArangoDbContainer initContainer(String imageName) {
        return new ArangoDbContainer(imageName);
    }

    @Override
    public int getPort() {
        return this.container.getServicePort();
    }

    @Override
    public String getHost() {
        return this.container.getHost();
    }

    public void registerProperties() {
        System.setProperty("arangodb.host", this.container.getHost());
        System.setProperty("arangodb.port", String.valueOf(this.container.getServicePort()));
    }

    public void initialize() {
        LOG.info("Trying to start the ArangoDB container");
        ContainerEnvironmentUtil.configureContainerStartup((GenericContainer)this.container, (String)"arangodb.container.startup.attempts", (int)2);
        this.container.start();
        this.registerProperties();
        LOG.info("ArangoDB instance running at {}", (Object)this.getServiceAddress());
    }

    public void shutdown() {
        LOG.info("Stopping the ArangoDB container");
        this.container.stop();
    }

    public ArangoDbContainer getContainer() {
        return this.container;
    }
}

