/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.cdi;

import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.apache.camel.cdi.CdiCamelExtension;
import org.apache.camel.test.cdi.Beans;
import org.apache.camel.test.cdi.CamelCdiTestExtension;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.jupiter.api.extension.ExtensionContext;

final class CamelCdiDeployment
implements ExtensionContext.Store.CloseableResource {
    private final BeanManager beanManager;
    private final WeldContainer container;

    CamelCdiDeployment(Class<?> test) {
        this.container = CamelCdiDeployment.createWeldContainer(test);
        this.beanManager = this.container.getBeanManager();
    }

    BeanManager beanManager() {
        return this.beanManager;
    }

    private static WeldContainer createWeldContainer(Class<?> test) {
        Weld weld = new Weld().containerId(String.format("camel-context-cdi-%s", test.getCanonicalName())).property(ConfigurationKey.RELAXED_CONSTRUCTION.get(), (Object)true).property("org.jboss.weld.se.shutdownHook", (Object)false).enableDiscovery().beanClasses((Class[])test.getDeclaredClasses()).addBeanClass(test).addExtension((Extension)new CdiCamelExtension());
        Beans beans = null;
        if (test.isAnnotationPresent(Beans.class)) {
            beans = test.getAnnotation(Beans.class);
            for (Class<?> alternative : beans.alternatives()) {
                weld.addBeanClass(alternative).addAlternative(alternative);
            }
            for (Class<?> clazz : beans.classes()) {
                weld.addBeanClass(clazz);
            }
            weld.addPackages(false, (Class[])beans.packages());
        }
        weld.addExtension((Extension)new CamelCdiTestExtension(beans));
        return weld.initialize();
    }

    public void close() {
        this.container.shutdown();
    }
}

