/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry.decorators;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.decorators.AbstractSpanDecorator;

public class SqlSpanDecorator
extends AbstractSpanDecorator {
    public static final String CAMEL_SQL_QUERY = "CamelSqlQuery";

    @Override
    public String getComponent() {
        return "sql";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.sql.SqlComponent";
    }

    @Override
    public void beforeTracingEvent(Span span, Exchange exchange, Endpoint endpoint) {
        super.beforeTracingEvent(span, exchange, endpoint);
        span.setTag("db.system", "sql");
        String query = (String)exchange.getIn().getHeader(CAMEL_SQL_QUERY, String.class);
        if (query != null) {
            span.setTag("db.statement", query);
        }
    }
}

