/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry.decorators;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.decorators.AbstractSpanDecorator;

public abstract class AbstractMessagingSpanDecorator
extends AbstractSpanDecorator {
    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return this.getDestination(exchange, endpoint);
    }

    @Override
    public void beforeTracingEvent(Span span, Exchange exchange, Endpoint endpoint) {
        super.beforeTracingEvent(span, exchange, endpoint);
        span.setTag("messaging.destination.name", this.getDestination(exchange, endpoint));
        String messageId = this.getMessageId(exchange);
        if (messageId != null) {
            span.setTag("messaging.message.id", messageId);
        }
    }

    protected String getDestination(Exchange exchange, Endpoint endpoint) {
        return AbstractMessagingSpanDecorator.stripSchemeAndOptions(endpoint);
    }

    protected String getMessageId(Exchange exchange) {
        return null;
    }
}

