/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.telemetry.SpanDecorator;
import org.apache.camel.telemetry.SpanDecoratorManager;
import org.apache.camel.telemetry.decorators.AbstractSpanDecorator;
import org.apache.camel.telemetry.decorators.ProcessorSpanDecorator;
import org.apache.camel.util.StringHelper;

public class SpanDecoratorManagerImpl
implements SpanDecoratorManager {
    protected static final Map<String, SpanDecorator> DECORATORS = new HashMap<String, SpanDecorator>();
    protected static SpanDecorator DEFAULT = new AbstractSpanDecorator(){

        @Override
        public String getComponent() {
            return "default";
        }

        @Override
        public String getComponentClassName() {
            return "default";
        }
    };

    @Override
    public SpanDecorator get(Endpoint endpoint) {
        SpanDecorator sd = this.getFromUri(endpoint.getEndpointUri());
        if (sd == null && endpoint instanceof DefaultEndpoint) {
            DefaultEndpoint de = (DefaultEndpoint)endpoint;
            Component comp = de.getComponent();
            String fqn = comp.getClass().getName();
            sd = DECORATORS.values().stream().filter(d -> fqn.equals(d.getComponentClassName())).findFirst().orElse(null);
        }
        if (sd == null) {
            sd = DEFAULT;
        }
        return sd;
    }

    SpanDecorator getFromUri(String uri) {
        SpanDecorator sd = null;
        String[] splitURI = StringHelper.splitOnCharacter((String)uri, (String)":", (int)2);
        if (splitURI[1] != null) {
            String scheme = splitURI[0];
            sd = DECORATORS.get(scheme);
        }
        return sd;
    }

    @Override
    public SpanDecorator get(String processorName) {
        return new ProcessorSpanDecorator(processorName);
    }

    static {
        ServiceLoader.load(SpanDecorator.class).forEach(d -> {
            SpanDecorator existing = DECORATORS.get(d.getComponent());
            if (existing == null || existing.getClass().isInstance(d)) {
                DECORATORS.put(d.getComponent(), (SpanDecorator)d);
            }
        });
    }
}

