/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetrydev;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.telemetry.Op;
import org.apache.camel.telemetrydev.DevSpanAdapter;
import org.apache.camel.telemetrydev.DevTrace;
import org.apache.camel.telemetrydev.DevTraceFormat;

class DevTraceFormatTree
implements DevTraceFormat {
    DevTraceFormatTree() {
    }

    @Override
    public String format(DevTrace trace) {
        StringWriter sw = new StringWriter();
        sw.append("\n| " + trace.getTraceId() + "\n");
        HashMap<String, Integer> depths = new HashMap<String, Integer>();
        int depth = 0;
        List<DevSpanAdapter> spans = trace.sortSpans();
        for (int j = 0; j < spans.size(); ++j) {
            DevSpanAdapter span = spans.get(j);
            String marker = this.getMarker(depths, span, j + 1 < spans.size() ? spans.get(j + 1) : null);
            String actualParentSpan = span.getParentSpanId();
            if (depths.containsKey(actualParentSpan)) {
                depth = depths.get(actualParentSpan);
            } else if (actualParentSpan != null) {
                depths.put(actualParentSpan, ++depth);
            } else {
                depth = 0;
            }
            if (depth > 0) {
                int i;
                sw.append(" ");
                for (i = 0; i < depth; ++i) {
                    sw.append("   ");
                }
                if (depth == 0) {
                    // empty if block
                }
                if (depth > 1) {
                    for (i = 1; i < depth; ++i) {
                        sw.append(" ");
                    }
                }
            }
            sw.append(String.format("%s\u2500\u2500 %s\n", marker, this.formatSpan(span)));
        }
        return sw.toString();
    }

    private String formatSpan(DevSpanAdapter span) {
        if (span.getTag("isDone") == null || !span.getTag("isDone").equals("true")) {
            return String.format("[error: span %s not closed!]", span.getTag("component"));
        }
        if (span.getTag("initTimestamp") == null || span.getTag("endTimestamp") == null) {
            return String.format("[error: span %s incomplete!]", span.getTag("component"));
        }
        String sentOrReceived = null;
        sentOrReceived = span.getTag("op").equals(Op.EVENT_SENT.name()) ? "-->" : (span.getTag("op").equals(Op.EVENT_RECEIVED.name()) ? "<--" : "");
        long nanos = (Long.parseLong(span.getTag("endTimestamp")) - Long.parseLong(span.getTag("initTimestamp"))) / 1000000L;
        String component = span.getTag("component");
        String camelUri = span.getTag("camel.uri");
        return String.format("| %s (%s) [%s] [%d millis] %s", camelUri == null ? "process" : camelUri, component, span.getSpanId(), nanos, sentOrReceived);
    }

    private String getMarker(HashMap<String, Integer> depths, DevSpanAdapter span, DevSpanAdapter next) {
        if (next == null) {
            return "\u2514";
        }
        Integer thisDepth = depths.get(span.getParentSpanId());
        Integer nextDepth = depths.get(next.getParentSpanId());
        if (thisDepth == null && nextDepth == null) {
            return "\u251c";
        }
        if (thisDepth != null && nextDepth != null && nextDepth >= thisDepth) {
            return "\u251c";
        }
        return "\u2514";
    }
}

