/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetrydev;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.telemetrydev.DevSpanAdapter;
import org.apache.camel.telemetrydev.DevTrace;

public class InMemoryCollector {
    private Map<String, Map<String, DevSpanAdapter>> traceDB = new HashMap<String, Map<String, DevSpanAdapter>>();

    public synchronized void push(String traceId, DevSpanAdapter span) {
        Map<String, DevSpanAdapter> spans = this.traceDB.get(traceId);
        if (spans == null) {
            spans = new HashMap<String, DevSpanAdapter>();
            this.traceDB.put(traceId, spans);
        }
        spans.put(span.getTag("spanid"), span);
    }

    public synchronized DevTrace get(String traceId) {
        Map<String, DevSpanAdapter> spans = this.traceDB.get(traceId);
        if (spans == null) {
            return null;
        }
        for (DevSpanAdapter span : spans.values()) {
            if ("true".equals(span.getTag("isDone"))) continue;
            return null;
        }
        this.traceDB.remove(traceId);
        return new DevTrace(traceId, new ArrayList<DevSpanAdapter>(spans.values()));
    }
}

