/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetrydev;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.telemetry.Span;

public class DevSpanAdapter
implements Span {
    private List<LogEntry> logEntries = new ArrayList<LogEntry>();
    private final Map<String, String> tags = new HashMap<String, String>();

    public static long nowMicros() {
        return System.currentTimeMillis() * 1000L;
    }

    public static DevSpanAdapter buildSpan(String operation) {
        return new DevSpanAdapter();
    }

    @JsonAnyGetter
    public Map<String, String> tags() {
        return this.tags;
    }

    public void setComponent(String component) {
        this.tags.put("component", component);
    }

    public void setError(boolean error) {
        this.tags.put("error", "" + error);
    }

    @JsonAnySetter
    public void setTag(String key, String value) {
        this.tags.put(key, value);
    }

    public String getTag(String key) {
        return this.tags.get(key);
    }

    public void log(Map<String, String> fields) {
        this.logEntries.add(new LogEntry(fields));
    }

    public List<LogEntry> getLogEntries() {
        return new ArrayList<LogEntry>(this.logEntries);
    }

    public void setLogEntries(List<LogEntry> logEntries) {
        this.logEntries = logEntries;
    }

    public String toString() {
        String toString = this.tags.get("traceid") + "-" + this.tags.get("spanid") + "-[";
        for (Map.Entry<String, String> entry : this.tags().entrySet()) {
            if (entry.getKey().equals("traceid") || entry.getKey().equals("spanid")) continue;
            toString = toString + entry.getKey() + "=" + entry.getValue() + ",";
        }
        toString = toString + "]";
        return toString;
    }

    public static final class LogEntry {
        private final long timestampMicros = DevSpanAdapter.nowMicros();
        private final Map<String, ?> fields;

        public LogEntry() {
            this(new HashMap());
        }

        public LogEntry(Map<String, ?> fields) {
            this.fields = fields;
        }

        public long timestampMicros() {
            return this.timestampMicros;
        }

        public Map<String, ?> getFields() {
            return this.fields;
        }

        public String toString() {
            return this.fields.toString();
        }
    }
}

