/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.OutgoingMessage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OutgoingGameMessage
extends OutgoingMessage {
    @JsonProperty(value="game_short_name")
    private String gameShortName;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;

    public OutgoingGameMessage(String chatId, Long replyToMessageId, String gameShortName, Boolean disableNotification, InlineKeyboardMarkup replyMarkup) {
        super.setChatId(chatId);
        super.setReplyToMessageId(replyToMessageId);
        super.setDisableNotification(disableNotification);
        this.gameShortName = gameShortName;
        this.disableNotification = disableNotification;
        this.replyMarkup = replyMarkup;
    }

    public OutgoingGameMessage() {
    }

    public void setGameShortName(String gameShortName) {
        this.gameShortName = gameShortName;
    }

    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    public String getGameShortName() {
        return this.gameShortName;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    public String toString() {
        return "OutgoingSendGameMessage{gameShortName='" + this.gameShortName + "', replyMarkup=" + String.valueOf(this.replyMarkup) + ", chatId='" + this.chatId + "', disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + "}";
    }
}

