/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultCachedVideo
extends InlineQueryResult {
    private static final String TYPE = "video";
    @JsonProperty(value="video_file_id")
    private String videoFileId;
    private String title;
    private String caption;
    private String description;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultCachedVideo() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVideoFileId() {
        return this.videoFileId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setVideoFileId(String videoFileId) {
        this.videoFileId = videoFileId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String videoFileId;
        private String title;
        private String caption;
        private String description;
        private String parseMode;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder videoFileId(String videoFileId) {
            this.videoFileId = videoFileId;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultCachedVideo build() {
            InlineQueryResultCachedVideo inlineQueryResultVideo = new InlineQueryResultCachedVideo();
            inlineQueryResultVideo.setType(InlineQueryResultCachedVideo.TYPE);
            inlineQueryResultVideo.setId(this.id);
            inlineQueryResultVideo.setReplyMarkup(this.replyMarkup);
            inlineQueryResultVideo.videoFileId = this.videoFileId;
            inlineQueryResultVideo.caption = this.caption;
            inlineQueryResultVideo.inputMessageContext = this.inputMessageContext;
            inlineQueryResultVideo.description = this.description;
            inlineQueryResultVideo.parseMode = this.parseMode;
            inlineQueryResultVideo.title = this.title;
            return inlineQueryResultVideo;
        }
    }
}

