/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu;

import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.tahu.TahuConfiguration;
import org.apache.camel.component.tahu.TahuDefaultComponent;
import org.apache.camel.component.tahu.TahuEdgeEndpoint;
import org.apache.camel.spi.annotations.Component;

@Component(value="tahu-edge")
public class TahuEdgeComponent
extends TahuDefaultComponent {
    public TahuEdgeComponent() {
    }

    public TahuEdgeComponent(CamelContext context) {
        super(context);
    }

    public TahuEdgeComponent(TahuConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected TahuEdgeEndpoint doCreateEndpoint(String uri, List<String> descriptorSegments, TahuConfiguration tahuConfig) throws Exception {
        String groupId = descriptorSegments.get(0);
        String edgeNode = descriptorSegments.get(1);
        String deviceId = null;
        if (descriptorSegments.size() == 3) {
            deviceId = descriptorSegments.get(2);
        }
        return new TahuEdgeEndpoint(uri, this, tahuConfig, groupId, edgeNode, deviceId);
    }

    public final TahuEdgeEndpoint createEdgeNodeEndpoint(String groupId, String edgeNode) throws Exception {
        String sparkplugDescriptorString = groupId + "/" + edgeNode;
        String uri = "tahu-edge:" + sparkplugDescriptorString;
        TahuEdgeEndpoint endpoint = (TahuEdgeEndpoint)this.createEndpoint(uri, sparkplugDescriptorString, Map.of());
        return endpoint;
    }
}

