/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tahu.handlers;

import java.util.List;
import java.util.function.BiConsumer;
import org.apache.camel.component.tahu.handlers.TahuHostApplicationEventHandler;
import org.eclipse.tahu.host.HostApplication;
import org.eclipse.tahu.host.api.HostApplicationEventHandler;
import org.eclipse.tahu.message.PayloadDecoder;
import org.eclipse.tahu.message.SparkplugBPayloadDecoder;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.Message;
import org.eclipse.tahu.message.model.Metric;
import org.eclipse.tahu.message.model.SparkplugBPayload;
import org.eclipse.tahu.model.MqttServerDefinition;
import org.eclipse.tahu.mqtt.RandomStartupDelay;

public class TahuHostApplication
extends HostApplication {
    TahuHostApplication(TahuHostApplicationEventHandler eventHandler, String hostId, List<String> sparkplugSubscriptions, List<MqttServerDefinition> serverDefinitions, RandomStartupDelay randomStartupDelay, PayloadDecoder<SparkplugBPayload> payloadDecoder, boolean onlineState) {
        super((HostApplicationEventHandler)eventHandler, hostId, sparkplugSubscriptions, serverDefinitions, randomStartupDelay, payloadDecoder, onlineState);
    }

    public void startup() {
        this.start(true);
    }

    public static final class HostApplicationBuilder {
        private String hostId;
        private List<String> sparkplugSubscriptions = List.of("spBv1.0/#");
        private List<MqttServerDefinition> serverDefinitions;
        private RandomStartupDelay randomStartupDelay = null;
        private PayloadDecoder<SparkplugBPayload> payloadDecoder = new SparkplugBPayloadDecoder();
        private boolean onlineState = true;
        private BiConsumer<EdgeNodeDescriptor, Message> onMessageConsumer;
        private BiConsumer<EdgeNodeDescriptor, Metric> onMetricConsumer;
        private volatile TahuHostApplication tahuHostApplication;

        public HostApplicationBuilder hostId(String hostId) {
            this.checkBuildState();
            this.hostId = hostId;
            return this;
        }

        public HostApplicationBuilder sparkplugSubscriptions(List<String> sparkplugSubscriptions) {
            this.checkBuildState();
            this.sparkplugSubscriptions = List.copyOf(sparkplugSubscriptions);
            return this;
        }

        public HostApplicationBuilder serverDefinitions(List<MqttServerDefinition> serverDefinitions) {
            this.checkBuildState();
            this.serverDefinitions = List.copyOf(serverDefinitions);
            return this;
        }

        public HostApplicationBuilder onlineState(boolean onlineState) {
            this.checkBuildState();
            this.onlineState = onlineState;
            return this;
        }

        public HostApplicationBuilder onMessageConsumer(BiConsumer<EdgeNodeDescriptor, Message> onMessageConsumer) {
            this.checkBuildState();
            this.onMessageConsumer = onMessageConsumer;
            return this;
        }

        public HostApplicationBuilder onMetricConsumer(BiConsumer<EdgeNodeDescriptor, Metric> onMetricConsumer) {
            this.checkBuildState();
            this.onMetricConsumer = onMetricConsumer;
            return this;
        }

        private void checkBuildState() throws IllegalStateException {
            if (this.tahuHostApplication != null) {
                throw new IllegalStateException("Unable to reuse a HostApplicationBuilder for multiple TahuHostApplication instances");
            }
        }

        public TahuHostApplication build() {
            TahuHostApplication cachedTahuHostApplication = this.tahuHostApplication;
            if (cachedTahuHostApplication == null) {
                TahuHostApplicationEventHandler eventHandler = new TahuHostApplicationEventHandler(this.onMessageConsumer, this.onMetricConsumer);
                cachedTahuHostApplication = this.tahuHostApplication = new TahuHostApplication(eventHandler, this.hostId, this.sparkplugSubscriptions, this.serverDefinitions, this.randomStartupDelay, this.payloadDecoder, this.onlineState);
            }
            return cachedTahuHostApplication;
        }
    }
}

