/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.swift.mt;

import com.prowidesoftware.JsonSerializable;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="swiftMt")
@Metadata(firstVersion="3.20.0", title="SWIFT MT")
public class SwiftMtDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private boolean writeInJson;

    public SwiftMtDataFormat() {
    }

    public SwiftMtDataFormat(boolean writeInJson) {
        this.writeInJson = writeInJson;
    }

    public String getDataFormatName() {
        return "swiftMt";
    }

    public void marshal(Exchange exchange, Object object, OutputStream stream) throws Exception {
        if (this.writeInJson) {
            stream.write(((JsonSerializable)object).toJson().getBytes(StandardCharsets.UTF_8));
        } else {
            ((AbstractMT)object).write(stream);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return AbstractMT.parse((InputStream)stream);
    }

    public boolean isWriteInJson() {
        return this.writeInJson;
    }

    public void setWriteInJson(boolean writeInJson) {
        this.writeInJson = writeInJson;
    }
}

