/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger.servlet;

import io.swagger.jaxrs.config.BeanConfig;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.impl.DefaultClassResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.swagger.RestSwaggerSupport;
import org.apache.camel.swagger.SwaggerHelper;
import org.apache.camel.swagger.servlet.ServletRestApiResponseAdapter;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RestSwaggerServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(RestSwaggerServlet.class);
    private final BeanConfig swaggerConfig = new BeanConfig();
    private final RestSwaggerSupport support = new RestSwaggerSupport();
    private final ClassResolver classResolver = new DefaultClassResolver();
    private volatile boolean initDone;
    private String apiContextIdPattern;
    private boolean apiContextIdListing;
    private boolean translateContextPath = true;

    public String getApiContextIdPattern() {
        return this.apiContextIdPattern;
    }

    public void setApiContextIdPattern(String apiContextIdPattern) {
        this.apiContextIdPattern = apiContextIdPattern;
    }

    public boolean isApiContextIdListing() {
        return this.apiContextIdListing;
    }

    public void setApiContextIdListing(boolean apiContextIdListing) {
        this.apiContextIdListing = apiContextIdListing;
    }

    public boolean isTranslateContextPath() {
        return this.translateContextPath;
    }

    public void setTranslateContextPath(boolean translateContextPath) {
        this.translateContextPath = translateContextPath;
    }

    public void init(ServletConfig config) throws ServletException {
        Object translate;
        Object listing;
        super.init(config);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = config.getInitParameter(name);
            parameters.put(name, value);
        }
        if (parameters.get("cors") != null) {
            LOG.warn("Use RestSwaggerCorsFilter when uisng this Servlet to enable CORS");
            parameters.remove("cors");
        }
        this.support.initSwagger(this.swaggerConfig, parameters);
        Object pattern = parameters.remove("apiContextIdPattern");
        if (pattern != null) {
            this.apiContextIdPattern = pattern.toString();
        }
        if ((listing = parameters.remove("apiContextIdListing")) != null) {
            this.apiContextIdListing = Boolean.valueOf(listing.toString());
        }
        if ((translate = parameters.remove("translateContextPath")) != null) {
            this.translateContextPath = Boolean.valueOf(translate.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.initDone) {
            this.initBaseAndApiPaths(request);
        }
        String contextId = null;
        String route = request.getPathInfo();
        String accept = request.getHeader("Accept");
        boolean json = false;
        boolean yaml = false;
        if (route != null && route.endsWith("/swagger.json")) {
            json = true;
            route = route.substring(0, route.length() - 13);
        } else if (route != null && route.endsWith("/swagger.yaml")) {
            yaml = true;
            route = route.substring(0, route.length() - 13);
        }
        if (accept != null && !json && !yaml) {
            json = accept.toLowerCase(Locale.US).contains("json");
            yaml = accept.toLowerCase(Locale.US).contains("yaml");
        }
        if (!json && !yaml) {
            json = true;
        }
        ServletRestApiResponseAdapter adapter = new ServletRestApiResponseAdapter(response);
        try {
            if (this.apiContextIdListing && (ObjectHelper.isEmpty((Object)route) || route.equals("/"))) {
                this.support.renderCamelContexts(adapter, contextId, this.apiContextIdPattern, json, yaml, null);
            } else {
                String name = null;
                if (ObjectHelper.isNotEmpty((Object)route)) {
                    if (route.startsWith("/")) {
                        route = route.substring(1);
                    }
                    if (ObjectHelper.isNotEmpty((Object)(name = route.split("/")[0]))) {
                        route = route.substring(name.length());
                    }
                } else {
                    List<String> contexts = this.support.findCamelContexts();
                    if (contexts.size() == 1) {
                        name = contexts.get(0);
                    }
                }
                boolean match = false;
                if (name != null) {
                    match = true;
                    if (this.apiContextIdPattern != null) {
                        match = "#name#".equals(this.apiContextIdPattern) ? true : EndpointHelper.matchPattern((String)name, (String)this.apiContextIdPattern);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Match contextId: {} with pattern: {} -> {}", new Object[]{name, this.apiContextIdPattern, match});
                        }
                    }
                }
                if (!match) {
                    adapter.noContent();
                } else {
                    this.support.renderResourceListing(adapter, this.swaggerConfig, name, route, json, yaml, this.classResolver, new RestConfiguration());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error rendering Swagger API due " + e.getMessage(), (Throwable)e);
        }
    }

    private void initBaseAndApiPaths(HttpServletRequest request) throws MalformedURLException {
        String base = this.swaggerConfig.getBasePath();
        if (base == null || !base.startsWith("http")) {
            URL url = new URL(request.getRequestURL().toString());
            if (base == null) {
                base = "";
            }
            String path = this.translateContextPath(request);
            if (this.swaggerConfig.getHost() == null) {
                this.swaggerConfig.setHost(url.getHost());
                if (url.getPort() != 80 && url.getPort() != -1) {
                    this.swaggerConfig.setHost(url.getHost() + ":" + url.getPort());
                } else {
                    this.swaggerConfig.setHost(url.getHost());
                }
            }
            this.swaggerConfig.setBasePath(SwaggerHelper.buildUrl(path, base));
        }
        this.initDone = true;
    }

    private String translateContextPath(HttpServletRequest request) {
        String path = request.getContextPath();
        if (!this.translateContextPath) {
            return path;
        }
        if (path.isEmpty() || path.equals("/")) {
            return "";
        }
        int idx = path.lastIndexOf("/");
        if (idx > 0) {
            return path.substring(0, idx);
        }
        return path;
    }
}

