/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.swagger.ExchangeRestApiResponseAdapter;
import org.apache.camel.swagger.RestSwaggerSupport;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSwaggerProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(RestSwaggerProcessor.class);
    private final BeanConfig swaggerConfig;
    private final RestSwaggerSupport support;
    private final String contextIdPattern;
    private final boolean contextIdListing;

    public RestSwaggerProcessor(String contextIdPattern, boolean contextIdListing, Map<String, Object> parameters) {
        this.contextIdPattern = contextIdPattern;
        this.contextIdListing = contextIdListing;
        this.support = new RestSwaggerSupport();
        this.swaggerConfig = new BeanConfig();
        if (parameters == null) {
            parameters = Collections.EMPTY_MAP;
        }
        this.support.initSwagger(this.swaggerConfig, parameters);
    }

    public void process(Exchange exchange) throws Exception {
        String contextId = exchange.getContext().getName();
        String route = (String)exchange.getIn().getHeader("CamelHttpPath", String.class);
        ExchangeRestApiResponseAdapter adapter = new ExchangeRestApiResponseAdapter(exchange);
        try {
            if (this.contextIdListing && (ObjectHelper.isEmpty((Object)route) || route.equals("/"))) {
                this.support.renderCamelContexts(adapter, contextId, this.contextIdPattern);
            } else {
                String name;
                if (ObjectHelper.isNotEmpty((Object)route)) {
                    if (route.startsWith("/")) {
                        route = route.substring(1);
                    }
                    name = route.split("/")[0];
                    if (route.startsWith(contextId)) {
                        route = route.substring(name.length());
                    }
                } else {
                    name = exchange.getContext().getName();
                }
                boolean match = true;
                if (this.contextIdPattern != null) {
                    match = "#name#".equals(this.contextIdPattern) ? name.equals(contextId) : EndpointHelper.matchPattern((String)name, (String)this.contextIdPattern);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Match contextId: {} with pattern: {} -> {}", new Object[]{name, this.contextIdPattern, match});
                    }
                }
                if (!match) {
                    adapter.noContent();
                } else {
                    this.support.renderResourceListing(adapter, this.swaggerConfig, name, route, exchange.getContext().getClassResolver());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error rendering Swagger API due " + e.getMessage(), (Throwable)e);
        }
    }
}

