/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.startup;

import org.apache.camel.StartupStep;
import org.apache.camel.support.startup.DefaultStartupStepRecorder;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStartupStepRecorder
extends DefaultStartupStepRecorder {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingStartupStepRecorder.class);

    public LoggingStartupStepRecorder() {
        this.setEnabled(true);
    }

    @Override
    protected void onEndStep(StartupStep step) {
        if (LOG.isInfoEnabled()) {
            String msg = this.logStep(step);
            LOG.info(msg);
        }
    }

    protected String logStep(StartupStep step) {
        long delta = step.getDuration();
        String pad = StringHelper.padString((int)step.getLevel());
        String out = String.format("%s", pad + step.getType());
        String out2 = String.format("%6s ms", delta);
        String out3 = String.format("%s(%s)", step.getDescription(), step.getName());
        return String.format("%s : %s - %s", out2, out, out3);
    }

    public String toString() {
        return "logging";
    }
}

