/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.processor.RestBindingAdvice;
import org.apache.camel.support.processor.RestBindingConfiguration;

public class RestBindingAdviceFactory {
    public static RestBindingAdvice build(CamelContext camelContext, RestBindingConfiguration bc) throws Exception {
        String mode = bc.getBindingMode();
        if ("off".equals(mode)) {
            return new RestBindingAdvice(camelContext, null, null, null, null, bc.getConsumes(), bc.getProduces(), mode, bc.isSkipBindingOnErrorCode(), bc.isClientRequestValidation(), bc.isEnableCORS(), bc.isEnableNoContentResponse(), bc.getCorsHeaders(), bc.getQueryDefaultValues(), bc.isRequiredBody(), bc.getRequiredQueryParameters(), bc.getRequiredHeaders());
        }
        RestConfiguration config = camelContext.getRestConfiguration();
        DataFormat json = null;
        DataFormat outJson = null;
        if (mode.contains("json") || "auto".equals(mode)) {
            String name = config.getJsonDataFormat();
            if (name != null) {
                Object instance = RestBindingAdviceFactory.lookupByName(camelContext, name);
                if (instance != null) {
                    throw new IllegalArgumentException("JsonDataFormat name: " + name + " must not be an existing bean instance from the registry");
                }
            } else {
                name = "jackson";
            }
            json = camelContext.createDataFormat(name);
            outJson = camelContext.createDataFormat(name);
            if (json != null) {
                RestBindingAdviceFactory.setupJson(camelContext, config, bc.getType(), bc.getTypeClass(), bc.getOutType(), bc.getOutTypeClass(), json, outJson);
            }
        }
        DataFormat jaxb = null;
        DataFormat outJaxb = null;
        if (mode.contains("xml") || "auto".equals(mode)) {
            String name = config.getXmlDataFormat();
            if (name != null) {
                Object instance = RestBindingAdviceFactory.lookupByName(camelContext, name);
                if (instance != null) {
                    throw new IllegalArgumentException("XmlDataFormat name: " + name + " must not be an existing bean instance from the registry");
                }
            } else {
                name = "jaxb";
            }
            jaxb = camelContext.createDataFormat(name);
            outJaxb = camelContext.createDataFormat(name);
            if (mode.contains("xml") && jaxb == null) {
                throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
            }
            if (jaxb != null) {
                PluginHelper.getRestBindingJaxbDataFormatFactory(camelContext).setupJaxb(camelContext, config, bc.getType(), bc.getTypeClass(), bc.getOutType(), bc.getOutTypeClass(), jaxb, outJaxb);
            }
        }
        return new RestBindingAdvice(camelContext, json, jaxb, outJson, outJaxb, bc.getConsumes(), bc.getProduces(), mode, bc.isSkipBindingOnErrorCode(), bc.isClientRequestValidation(), bc.isEnableCORS(), bc.isEnableNoContentResponse(), bc.getCorsHeaders(), bc.getQueryDefaultValues(), bc.isRequiredBody(), bc.getRequiredQueryParameters(), bc.getRequiredHeaders());
    }

    protected static void setupJson(CamelContext camelContext, RestConfiguration config, String type, Class<?> typeClass, String outType, Class<?> outTypeClass, DataFormat json, DataFormat outJson) throws Exception {
        Class<Object> clazz = null;
        boolean useList = false;
        if (typeClass != null) {
            useList = typeClass.isArray();
            clazz = useList ? typeClass.getComponentType() : typeClass;
        } else if (type != null) {
            useList = type.endsWith("[]");
            String typeName = useList ? type.substring(0, type.length() - 2) : type;
            clazz = camelContext.getClassResolver().resolveMandatoryClass(typeName);
        }
        BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection(camelContext);
        if (clazz != null) {
            beanIntrospection.setProperty(camelContext, (Object)json, "unmarshalType", clazz);
            beanIntrospection.setProperty(camelContext, (Object)json, "useList", (Object)useList);
        }
        RestBindingAdviceFactory.setAdditionalConfiguration(camelContext, config, json, "json.in.");
        Class<Object> outClazz = null;
        boolean outUseList = false;
        if (outTypeClass != null) {
            outUseList = outTypeClass.isArray();
            outClazz = outUseList ? outTypeClass.getComponentType() : outTypeClass;
        } else if (outType != null) {
            outUseList = outType.endsWith("[]");
            String typeName = outUseList ? outType.substring(0, outType.length() - 2) : outType;
            outClazz = camelContext.getClassResolver().resolveMandatoryClass(typeName);
        }
        if (outClazz != null) {
            beanIntrospection.setProperty(camelContext, (Object)outJson, "unmarshalType", outClazz);
            beanIntrospection.setProperty(camelContext, (Object)outJson, "useList", (Object)outUseList);
        }
        RestBindingAdviceFactory.setAdditionalConfiguration(camelContext, config, outJson, "json.out.");
    }

    private static void setAdditionalConfiguration(CamelContext camelContext, RestConfiguration config, DataFormat dataFormat, String prefix) {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap<String, Object> copy = new HashMap<String, Object>();
            for (Map.Entry entry : config.getDataFormatProperties().entrySet()) {
                String key = (String)entry.getKey();
                boolean known = RestBindingAdviceFactory.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            PropertyBindingSupport.build().bind(camelContext, dataFormat, copy);
        }
    }

    private static boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }

    private static Object lookupByName(CamelContext camelContext, String name) {
        if (name == null) {
            return null;
        }
        if (EndpointHelper.isReferenceParameter(name)) {
            return EndpointHelper.resolveReferenceParameter(camelContext, name, Object.class, false);
        }
        return camelContext.getRegistry().lookupByName(name);
    }
}

