/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.RouteOnDemandReloadStrategy;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed LoadOnDemandReloadStrategy")
public class LoadOnDemandReloadStrategy
extends RouteOnDemandReloadStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(LoadOnDemandReloadStrategy.class);

    public LoadOnDemandReloadStrategy() {
        this.setRemoveAllRoutes(false);
        this.setScheduler(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Object source, List<String> files, boolean restart) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            this.setLastError(null);
            ClassLoader acl = this.getCamelContext().getApplicationContextClassLoader();
            if (acl != null) {
                Thread.currentThread().setContextClassLoader(acl);
            }
            this.doOnReload(source, files, restart);
            this.incSucceededCounter();
        }
        catch (Exception e) {
            this.setLastError(e);
            this.incFailedCounter();
            LOG.warn("Error loading routes due to {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    protected void doOnReload(Object source, List<String> files, boolean restart) throws Exception {
        ContextReloadStrategy contextReloadStrategy;
        ArrayList<Resource> properties = new ArrayList<Resource>();
        ArrayList<Resource> groovy = new ArrayList<Resource>();
        ArrayList<Resource> routes = new ArrayList<Resource>();
        for (Resource resource : this.findReloadedResources(files)) {
            String string = FileUtil.onlyExt((String)resource.getLocation());
            if ("properties".equals(string)) {
                properties.add(resource);
                continue;
            }
            if ("groovy".equals(string)) {
                groovy.add(resource);
                continue;
            }
            routes.add(resource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("On-demand reload scanned {} files (properties: {}, routes: {}, groovy: {})", new Object[]{properties.size() + routes.size(), properties.size(), routes.size(), groovy.size()});
        }
        boolean reloaded = false;
        for (Resource resource : properties) {
            reloaded |= this.onPropertiesReload(resource, false);
        }
        for (Resource resource : groovy) {
            reloaded |= this.onGroovyReload(resource, false);
        }
        if (!routes.isEmpty()) {
            this.onRouteReload(routes, false);
        }
        if ((restart || reloaded) && (contextReloadStrategy = (ContextReloadStrategy)this.getCamelContext().hasService(ContextReloadStrategy.class)) != null) {
            contextReloadStrategy.onReload(source);
        }
    }

    @Override
    public void onReload(Object source) {
    }

    @Override
    protected List<Resource> findReloadedResources(Object source) throws Exception {
        ArrayList<Resource> answer = new ArrayList<Resource>();
        if (source instanceof List) {
            List list = (List)source;
            for (Object l : list) {
                File f = new File(l.toString());
                if (!f.isFile() || !f.exists()) continue;
                Resource res = ResourceHelper.resolveResource(this.getCamelContext(), "file:" + f.getAbsolutePath());
                answer.add(res);
            }
        }
        return answer;
    }
}

