/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointHelper.class);
    private static final AtomicLong ENDPOINT_COUNTER = new AtomicLong();

    private EndpointHelper() {
    }

    public static String resolveEndpointUriPropertyPlaceholders(CamelContext camelContext, String uri) {
        try {
            uri = camelContext.getCamelContextExtension().resolvePropertyPlaceholders(uri, true);
            if (uri == null || uri.isEmpty()) {
                return uri;
            }
            String prefix = "{{?";
            if (uri.contains(prefix)) {
                String unresolved = uri;
                uri = EndpointHelper.doResolveEndpointUriOptionalPropertyPlaceholders(unresolved);
                LOG.trace("Unresolved optional placeholders removed from uri: {} -> {}", (Object)unresolved, (Object)uri);
            }
            LOG.trace("Resolved property placeholders with uri: {}", (Object)uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        return uri;
    }

    private static String doResolveEndpointUriOptionalPropertyPlaceholders(String uri) throws URISyntaxException {
        String prefix = "{{?";
        int pos = 0;
        for (int i = 0; i < uri.length(); ++i) {
            char ch = uri.charAt(i);
            if (ch != '?') continue;
            if (i > 2) {
                char ch1 = uri.charAt(i - 1);
                char ch2 = uri.charAt(i - 2);
                if (ch1 == '{' || ch2 == '{') continue;
                pos = i;
                break;
            }
            pos = i;
            break;
        }
        String base = pos > 0 ? uri.substring(0, pos) : uri;
        String query = pos > 0 ? uri.substring(pos + 1) : null;
        String pattern = "\\{\\{?.*}}";
        base = base.replaceAll(pattern, "");
        if (query != null && query.contains(prefix)) {
            Map params = URISupport.parseQuery((String)query);
            LinkedHashMap keep = new LinkedHashMap();
            for (Map.Entry entry : params.entrySet()) {
                int dot;
                String s;
                Object value;
                String key = (String)entry.getKey();
                if (key.startsWith(prefix) || (value = entry.getValue()) instanceof String && ((s = value.toString()).startsWith(prefix) || (dot = s.indexOf(58)) > 0 && dot < s.length() - 1 && (s = s.substring(dot + 1)).startsWith(prefix))) continue;
                keep.put(key, value);
            }
            query = URISupport.createQueryString(keep);
        }
        uri = query != null && !query.isEmpty() ? base + "?" + query : base;
        return uri;
    }

    public static String normalizeEndpointUri(String uri) {
        try {
            uri = URISupport.normalizeUri((String)uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollEndpoint(Endpoint endpoint, Processor processor, long timeout) throws Exception {
        PollingConsumer consumer = endpoint.createPollingConsumer();
        try {
            Exchange exchange;
            ServiceHelper.startService((Service)consumer);
            while ((exchange = consumer.receive(timeout)) != null) {
                processor.process(exchange);
            }
        }
        finally {
            try {
                ServiceHelper.stopAndShutdownService((Object)consumer);
            }
            catch (Exception e) {
                LOG.warn("Failed to stop PollingConsumer: {}. This example is ignored.", (Object)consumer, (Object)e);
            }
        }
    }

    public static void pollEndpoint(Endpoint endpoint, Processor processor) throws Exception {
        EndpointHelper.pollEndpoint(endpoint, processor, 1000L);
    }

    public static boolean matchEndpoint(CamelContext context, String uri, String pattern) {
        if (context != null) {
            try {
                uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(context, uri);
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        }
        uri = EndpointHelper.normalizeEndpointUri(uri);
        boolean match = PatternHelper.matchPattern(EndpointHelper.toggleUriSchemeSeparators(uri), pattern);
        if (!(match |= PatternHelper.matchPattern(uri, pattern)) && pattern != null && pattern.contains("?")) {
            try {
                pattern = URISupport.normalizeUri((String)pattern);
                match = EndpointHelper.toggleUriSchemeSeparators(uri).equalsIgnoreCase(pattern);
                return match || uri.equalsIgnoreCase(pattern);
            }
            catch (URISyntaxException e) {
                return false;
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        }
        return match;
    }

    private static String toggleUriSchemeSeparators(String normalizedUri) {
        if (normalizedUri.contains("://")) {
            String scheme = StringHelper.before((String)normalizedUri, (String)"://");
            String path = StringHelper.after((String)normalizedUri, (String)"://");
            return scheme + ":" + path;
        }
        String scheme = StringHelper.before((String)normalizedUri, (String)":");
        String path = StringHelper.after((String)normalizedUri, (String)":");
        return scheme + "://" + path;
    }

    public static boolean isReferenceParameter(String parameter) {
        return parameter != null && parameter.trim().startsWith("#") && parameter.trim().length() > 1;
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type) {
        return EndpointHelper.resolveReferenceParameter(context, value, type, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type, boolean mandatory) {
        Object answer;
        block12: {
            answer = null;
            if (value.startsWith("#class:")) {
                try {
                    answer = EndpointHelper.createBean(context, value, type);
                }
                catch (Exception e) {
                    throw new NoSuchBeanException(value, (Throwable)e);
                }
            }
            if (value.startsWith("#type:")) {
                try {
                    value = value.substring(6);
                    Class clazz = context.getClassResolver().resolveMandatoryClass(value);
                    Set set = context.getRegistry().findByType(clazz);
                    if (set.size() == 1) {
                        answer = set.iterator().next();
                        break block12;
                    } else if (set.size() > 1) {
                        throw new NoSuchBeanException(value, "Found " + set.size() + " beans of type: " + clazz + ". Only 1 bean instance is supported.");
                    }
                    break block12;
                }
                catch (ClassNotFoundException e) {
                    throw new NoSuchBeanException(value, (Throwable)e);
                }
            }
            value = value.replace("#bean:", "");
            answer = CamelContextHelper.lookup(context, value = value.replace("#", ""), type);
            if (answer == null) {
                answer = CamelContextHelper.lookup(context, value);
            }
        }
        if (mandatory && answer == null) {
            if (type == null) throw new NoSuchBeanException(value);
            throw new NoSuchBeanException(value, type.getTypeName());
        }
        if (answer == null) return (T)answer;
        if (mandatory) {
            answer = CamelContextHelper.convertTo(context, type, answer);
            return (T)answer;
        }
        answer = CamelContextHelper.tryConvertTo(context, type, answer);
        return (T)answer;
    }

    private static <T> T createBean(CamelContext camelContext, String name, Class<T> type) throws Exception {
        String factoryMethod = null;
        String parameters = null;
        String className = name.substring(7);
        if (className.endsWith(")") && className.indexOf(40) != -1) {
            parameters = StringHelper.after((String)className, (String)"(");
            parameters = parameters.substring(0, parameters.length() - 1);
            className = StringHelper.before((String)className, (String)"(");
        }
        if (className != null && className.indexOf(35) != -1) {
            factoryMethod = StringHelper.after((String)className, (String)"#");
            className = StringHelper.before((String)className, (String)"#");
        }
        Class clazz = camelContext.getClassResolver().resolveMandatoryClass(className);
        Object answer = factoryMethod != null && parameters != null ? PropertyBindingSupport.newInstanceFactoryParameters(camelContext, clazz, factoryMethod, parameters) : (factoryMethod != null ? camelContext.getInjector().newInstance(type, factoryMethod) : (parameters != null ? PropertyBindingSupport.newInstanceConstructorParameters(camelContext, clazz, parameters) : camelContext.getInjector().newInstance(clazz)));
        if (answer == null) {
            throw new IllegalStateException("Cannot create bean: " + name);
        }
        return type.cast(answer);
    }

    public static <T> List<T> resolveReferenceListParameter(CamelContext context, String value, Class<T> elementType) {
        if (value == null) {
            return new ArrayList();
        }
        List<String> elements = Arrays.asList(value.split(","));
        if (elements.size() == 1) {
            Object bean = EndpointHelper.resolveReferenceParameter(context, elements.get(0).trim(), Object.class);
            if (bean instanceof List) {
                return (List)bean;
            }
            ArrayList<T> singleElementList = new ArrayList<T>();
            singleElementList.add(elementType.cast(bean));
            return singleElementList;
        }
        ArrayList<T> result = new ArrayList<T>(elements.size());
        for (String element : elements) {
            result.add(EndpointHelper.resolveReferenceParameter(context, element.trim(), elementType));
        }
        return result;
    }

    public static <T> T resolveParameter(CamelContext context, String value, Class<T> type) {
        Object result = EndpointHelper.isReferenceParameter(value) ? EndpointHelper.resolveReferenceParameter(context, value, type) : context.getTypeConverter().convertTo(type, (Object)value);
        return result;
    }

    public static String getRouteIdFromEndpoint(Endpoint endpoint) {
        if (endpoint == null || endpoint.getCamelContext() == null) {
            return null;
        }
        List routes = endpoint.getCamelContext().getRoutes();
        for (Route route : routes) {
            if (!route.getEndpoint().equals(endpoint) && !route.getEndpoint().getEndpointKey().equals(endpoint.getEndpointKey())) continue;
            return route.getId();
        }
        return null;
    }

    public static String createEndpointId() {
        return "endpoint" + ENDPOINT_COUNTER.incrementAndGet();
    }

    public static String lookupEndpointRegistryId(Endpoint endpoint) {
        if (endpoint == null || endpoint.getCamelContext() == null) {
            return null;
        }
        Endpoint delegate = null;
        if (endpoint instanceof DelegateEndpoint) {
            delegate = ((DelegateEndpoint)endpoint).getEndpoint();
        }
        Map map = endpoint.getCamelContext().getRegistry().findByTypeWithName(Endpoint.class);
        for (Map.Entry entry : map.entrySet()) {
            if (!((Endpoint)entry.getValue()).equals(endpoint) && !((Endpoint)entry.getValue()).equals(delegate)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public static ExchangePattern resolveExchangePatternFromUrl(String url) {
        if (url.contains("exchangePattern=InOnly")) {
            return ExchangePattern.InOnly;
        }
        if (url.contains("exchangePattern=InOut")) {
            return ExchangePattern.InOut;
        }
        return null;
    }
}

